/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.deployment;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.util.StringHelper;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class AddServiceCategoryBean {
    private Logger logger = Logger.getLogger(AddServiceCategoryBean.class);
    private String categoryId;
    private CategoryValueTO selectedCategory = new CategoryValueTO();
    private List<CategoryTO> categories = new ArrayList();
    private List<CategoryValueTO> categoryValues = new ArrayList();
    private boolean valueAvailable = false;

    public void loadServiceCategories() throws LocalizedError {
        try {
            this.categories = DragonServiceFactory.getInstance().getTModelManager().loadServiceCategories();
            this.categories.add(0, new CategoryTO("", "No Category selected", null));
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadCategoryValues(String categoryId) throws LocalizedError {
        if (!StringHelper.isNullOrEmpty((String)categoryId)) {
            try {
                this.categoryValues = DragonServiceFactory.getInstance().getTModelManager().loadCategoryValues(categoryId);
                this.valueAvailable = this.categoryValues != null && !this.categoryValues.isEmpty();
            }
            catch (DragonDelegateException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
    }

    public List<CategoryTO> getCategories() {
        return this.categories;
    }

    public List<CategoryValueTO> getCategoryValues() {
        if (this.categoryValues == null || this.categoryValues.isEmpty()) {
            this.categoryValues.add(new CategoryValueTO("", "No category values", null));
        }
        return this.categoryValues;
    }

    public String addCategoryToService(String techServiceId) throws IError {
        try {
            if (this.valueAvailable) {
                DragonServiceFactory.getInstance().getTechServiceManager().addCategory(techServiceId, this.categoryId, this.selectedCategory.getId());
            } else {
                DragonServiceFactory.getInstance().getTechServiceManager().addCategory(techServiceId, this.categoryId, this.selectedCategory.getValue(), this.selectedCategory.getDescription());
            }
        }
        catch (DeploymentException e) {
            NonLocalizedError error = new NonLocalizedError("Can't add category to service.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setCategoryValues(List<CategoryValueTO> categoryValues) {
        this.categoryValues = categoryValues;
    }

    public boolean isValueAvailable() {
        return this.valueAvailable;
    }

    public void setValueAvailable(boolean valueAvailable) {
        this.valueAvailable = valueAvailable;
    }

    public CategoryValueTO getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(CategoryValueTO selectedCategory) {
        this.selectedCategory = selectedCategory;
    }
}

