/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.deployment;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

public class ListOfEndpointsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<EndpointTO> endpoints;
    private String searchCriteria;
    private boolean isSearchOnName;
    private boolean isSearchOnService;
    private boolean isSearchOnProvider;
    private String serviceId;
    private String tag;

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<EndpointTO> getEndpoints() {
        return this.endpoints;
    }

    public String loadEndpointsByTag(HttpServletRequest request) throws LocalizedError {
        this.tag = request.getParameter("tag");
        try {
            this.endpoints = DragonServiceFactory.getInstance().getEndpointManager().getEndpointsByTag(this.tag);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String removeTagFromEndpoint(HttpServletRequest request) throws LocalizedError {
        String endpointId = request.getParameter("endpointId");
        this.tag = request.getParameter("tag");
        try {
            DragonServiceFactory.getInstance().getEndpointManager().removeTag(this.tag, endpointId);
            this.endpoints = DragonServiceFactory.getInstance().getEndpointManager().getEndpointsByTag(this.tag);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void loadAll() throws LocalizedError {
        try {
            this.endpoints = DragonServiceFactory.getInstance().getEndpointManager().getAllEndpoints(this.createSortOption(SortCriteria.ENDPOINT_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public List<EndpointTO> loadByTechService() throws LocalizedError {
        try {
            this.endpoints = DragonServiceFactory.getInstance().getEndpointManager().getEndpointsByTechService(this.serviceId, this.createSortOption(SortCriteria.ENDPOINT_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return this.endpoints;
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public boolean isSearchOnName() {
        return this.isSearchOnName;
    }

    public void setSearchOnName(boolean isSearchOnName) {
        this.isSearchOnName = isSearchOnName;
    }

    public boolean isSearchOnService() {
        return this.isSearchOnService;
    }

    public void setSearchOnService(boolean isSearchOnService) {
        this.isSearchOnService = isSearchOnService;
    }

    public boolean isSearchOnProvider() {
        return this.isSearchOnProvider;
    }

    public void setSearchOnProvider(boolean isSearchOnProvider) {
        this.isSearchOnProvider = isSearchOnProvider;
    }
}

