/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.lifecycle;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleStepServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleUnderStepServiceTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;

public class LifeCycleServiceBean {
    private List<LifecycleTO> allLifecycles;
    private String idLifecycle;
    private String lifecycleName;
    private String lifecycleStepName;
    private String lifecycleStepId;
    private LifecycleServiceTO lifecycleServiceTO;
    private String id;
    private List<LifecycleStepServiceTO> listStepService;
    private LifecycleStepServiceTO lifeStepServiceTO;
    private List<Object> items;
    private List<LifecycleUnderStepServiceTO> listUnderStepService;
    private List<String> underStepServiceId;
    private String idService;
    private boolean viewLifecycleInfo = false;
    private boolean hasNoLifecycle = true;
    private boolean noLifecycleExist = false;
    private boolean validate = false;

    public boolean load(String idServiceUI) throws Exception {
        this.idService = idServiceUI;
        this.lifecycleServiceTO = DragonServiceFactory.getInstance().getLifecycleServiceManager().getLifecycleServiceByTechnicalService(this.idService);
        if (this.lifecycleServiceTO == null || this.lifecycleServiceTO.getId() == null) {
            this.allLifecycles = DragonServiceFactory.getInstance().getLifecycleManager().getAll();
            if (this.allLifecycles == null || this.allLifecycles.isEmpty()) {
                this.noLifecycleExist = true;
                this.hasNoLifecycle = false;
                this.viewLifecycleInfo = false;
            } else {
                this.noLifecycleExist = false;
                this.hasNoLifecycle = true;
                this.viewLifecycleInfo = false;
            }
        } else {
            this.id = this.lifecycleServiceTO.getId();
            this.lifecycleName = this.lifecycleServiceTO.getName();
            this.items = DragonServiceFactory.getInstance().getLifecycleServiceManager().getAllStepAndUnderStepService(this.lifecycleServiceTO);
            this.hasNoLifecycle = false;
            this.viewLifecycleInfo = true;
        }
        return true;
    }

    public void associateLifecycle(String id) throws Exception {
        this.lifecycleServiceTO = new LifecycleServiceTO();
        LifecycleTO lifecycle = new LifecycleTO();
        lifecycle.setId(id);
        TechnicalServiceTO techService = new TechnicalServiceTO();
        techService.setId(this.idService);
        this.lifecycleServiceTO.setLifecycleTO(lifecycle);
        this.lifecycleServiceTO.setTechnicalServiceTO(techService);
        DragonServiceFactory.getInstance().getLifecycleServiceManager().saveOrUpdateLifecycleService(this.lifecycleServiceTO);
    }

    public void checkOrValidateStep(String login) throws Exception {
        if (this.listUnderStepService != null && !this.listUnderStepService.isEmpty()) {
            DragonServiceFactory.getInstance().getLifecycleServiceManager().updateCheckUnderStep(this.underStepServiceId, this.listUnderStepService);
            this.lifeStepServiceTO.setListUnderStepService(this.listUnderStepService);
        }
        if (this.validate) {
            DragonServiceFactory.getInstance().getLifecycleServiceManager().closeCurrentStepAndStartNextStep(this.lifeStepServiceTO, login);
        } else {
            DragonServiceFactory.getInstance().getLifecycleServiceManager().openCurrentStepAndCloseNextStep(this.lifeStepServiceTO);
        }
        this.load(this.idService);
    }

    public void loadLifecycleStep() throws Exception {
        this.lifeStepServiceTO = DragonServiceFactory.getInstance().getLifecycleServiceManager().getStepService(this.lifecycleStepId);
        this.listUnderStepService = new ArrayList();
        if (this.lifeStepServiceTO.getListUnderStepService() != null && !this.lifeStepServiceTO.getListUnderStepService().isEmpty()) {
            this.listUnderStepService = this.lifeStepServiceTO.getListUnderStepService();
        }
        this.underStepServiceId = new ArrayList();
        if (this.listUnderStepService != null && !this.listUnderStepService.isEmpty()) {
            for (LifecycleUnderStepServiceTO underStepService : this.listUnderStepService) {
                if (underStepService.getEndDate() == 0L) continue;
                this.underStepServiceId.add(underStepService.getId());
            }
        }
        this.validate = this.lifeStepServiceTO.getEndDate() != 0L;
    }

    public void deleteLifecycle(HttpServletRequest request) throws Exception {
        this.id = request.getParameter("idLifecycleService");
        DragonServiceFactory.getInstance().getLifecycleServiceManager().deleteLifecycleService(this.id);
    }

    public String getHtmlName(Object o) {
        if (o instanceof LifecycleStepServiceTO) {
            return ((LifecycleStepServiceTO)o).getName();
        }
        return ((LifecycleUnderStepServiceTO)o).getName();
    }

    public String getHtmlStartDate(Object o) {
        Locale locale = Locale.FRANCE;
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (o instanceof LifecycleStepServiceTO) {
            if (((LifecycleStepServiceTO)o).getStartDate() == 0L) {
                return null;
            }
            return dateFormat.format(((LifecycleStepServiceTO)o).getStartDate());
        }
        return null;
    }

    public String getHtmlEndDate(Object o) {
        Locale locale = Locale.FRANCE;
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (o instanceof LifecycleStepServiceTO) {
            if (((LifecycleStepServiceTO)o).getEndDate() != 0L) {
                String dateName = dateFormat.format(((LifecycleStepServiceTO)o).getEndDate());
                return dateName;
            }
            return null;
        }
        if (((LifecycleUnderStepServiceTO)o).getEndDate() != 0L) {
            String dateName = dateFormat.format(((LifecycleUnderStepServiceTO)o).getEndDate());
            return dateName;
        }
        return null;
    }

    public String getHtmlPerson(Object o) {
        if (o instanceof LifecycleStepServiceTO) {
            return ((LifecycleStepServiceTO)o).getPerson().getName();
        }
        return null;
    }

    public String getRowType(Object o) {
        if (o instanceof LifecycleStepServiceTO) {
            if (((LifecycleStepServiceTO)o).getStartDate() != 0L && ((LifecycleStepServiceTO)o).getEndDate() == 0L) {
                return "currentStep";
            }
            return "step";
        }
        return "checkpoint";
    }

    public String searchUserId(Object o) {
        if (o != null) {
            if (o instanceof LifecycleStepServiceTO) {
                return ((LifecycleStepServiceTO)o).getPerson().getId();
            }
            return null;
        }
        return "";
    }

    public String searchId(Object o) {
        if (o instanceof LifecycleStepServiceTO) {
            return ((LifecycleStepServiceTO)o).getId();
        }
        return null;
    }

    public void affectId(HttpServletRequest request) {
        this.lifecycleStepId = request.getParameter("lifecycleStepId");
    }

    public boolean isStep(Object o) {
        if (o instanceof LifecycleStepServiceTO) {
            return ((LifecycleStepServiceTO)o).getStartDate() != 0L && ((LifecycleStepServiceTO)o).isCanChange();
        }
        return false;
    }

    public boolean isStepWithUser(Object o) {
        if (o instanceof LifecycleStepServiceTO) {
            return ((LifecycleStepServiceTO)o).getStartDate() != 0L && ((LifecycleStepServiceTO)o).getPerson().getId() != null;
        }
        return false;
    }

    public String isValidated() {
        if (this.validate) {
            return "true";
        }
        return "false";
    }

    public List<LifecycleTO> getAllLifecycles() {
        return this.allLifecycles;
    }

    public void setAllLifecycles(List<LifecycleTO> allLifecycles) {
        this.allLifecycles = allLifecycles;
    }

    public String getIdLifecycle() {
        return this.idLifecycle;
    }

    public void setIdLifecycle(String idLifecycle) {
        this.idLifecycle = idLifecycle;
    }

    public String getLifecycleName() {
        return this.lifecycleName;
    }

    public void setLifecycleName(String lifecycleName) {
        this.lifecycleName = lifecycleName;
    }

    public String getLifecycleStepName() {
        return this.lifecycleStepName;
    }

    public void setLifecycleStepName(String lifecycleStepName) {
        this.lifecycleStepName = lifecycleStepName;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public List<String> getUnderStepServiceId() {
        return this.underStepServiceId;
    }

    public void setUnderStepServiceId(List<String> underStepServiceId) {
        this.underStepServiceId = underStepServiceId;
    }

    public String getLifecycleStepId() {
        return this.lifecycleStepId;
    }

    public void setLifecycleStepId(String lifecycleStepId) {
        this.lifecycleStepId = lifecycleStepId;
    }

    public boolean isViewLifecycleInfo() {
        return this.viewLifecycleInfo;
    }

    public void setViewLifecycleInfo(boolean viewLifecycleInfo) {
        this.viewLifecycleInfo = viewLifecycleInfo;
    }

    public boolean isHasNoLifecycle() {
        return this.hasNoLifecycle;
    }

    public void setHasNoLifecycle(boolean hasNoLifecycle) {
        this.hasNoLifecycle = hasNoLifecycle;
    }

    public LifecycleServiceTO getLifecycleServiceTO() {
        return this.lifecycleServiceTO;
    }

    public void setLifecycleServiceTO(LifecycleServiceTO lifecycleServiceTO) {
        this.lifecycleServiceTO = lifecycleServiceTO;
    }

    public List<LifecycleStepServiceTO> getListStepService() {
        return this.listStepService;
    }

    public void setListStepService(List<LifecycleStepServiceTO> listStepService) {
        this.listStepService = listStepService;
    }

    public LifecycleStepServiceTO getLifeStepServiceTO() {
        return this.lifeStepServiceTO;
    }

    public void setLifeStepServiceTO(LifecycleStepServiceTO lifeStepServiceTO) {
        this.lifeStepServiceTO = lifeStepServiceTO;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdService() {
        return this.idService;
    }

    public void setIdService(String idService) {
        this.idService = idService;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public List<LifecycleUnderStepServiceTO> getListUnderStepService() {
        return this.listUnderStepService;
    }

    public void setListUnderStepService(List<LifecycleUnderStepServiceTO> listUnderStepService) {
        this.listUnderStepService = listUnderStepService;
    }

    public boolean isNoLifecycleExist() {
        return this.noLifecycleExist;
    }

    public void setNoLifecycleExist(boolean noLifecycleExist) {
        this.noLifecycleExist = noLifecycleExist;
    }
}

