/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.lifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.lifecycle.LifecycleException;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleStepTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleUnderStepTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class LifecycleBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private String id;
    private String name;
    private List<LifecycleTO> lifecycles = new ArrayList();
    private LifecycleTO lifecycle;
    private List<LifecycleStepTO> listLifecycleStep = new ArrayList();
    private String stepName;
    private String idStep;
    private int idx;
    private String underStepName;
    private String idUnderStep;
    private List<LifecycleUnderStepTO> listUnderStep = new ArrayList();
    private List<TechnicalServiceTO> listLinkedServices;
    private String[] selectedServices;
    boolean visible;
    boolean canCreateUnderStep;
    boolean canUpdateUnderStep;
    boolean canChangeLifecycle;
    boolean canDeleteStepAndUnderStep;

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        this.id = iRequest.getParameter("lifecycleId");
        this.load();
    }

    private void load() throws LocalizedError {
        try {
            this.lifecycle = DragonServiceFactory.getInstance().getLifecycleManager().getLifecycle(this.id);
            this.name = this.lifecycle.getName();
            this.listLifecycleStep = this.lifecycle.getListLifecycleStep();
            this.listLinkedServices = DragonServiceFactory.getInstance().getLifecycleManager().getAllLinkedServices(this.id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.visible = this.listLifecycleStep != null && !this.listLifecycleStep.isEmpty();
    }

    public void loadStep(HttpServletRequest iRequest) throws LocalizedError {
        this.idStep = iRequest.getParameter("lifecycleStepId");
        this.loadStep();
    }

    private void loadStep() throws LocalizedError {
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        try {
            lifecycleStepTO = DragonServiceFactory.getInstance().getLifecycleManager().getStep(this.idStep);
            this.stepName = lifecycleStepTO.getName();
            this.idx = lifecycleStepTO.getIdx();
            this.listUnderStep = lifecycleStepTO.getListLifecycleUnderStep();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.canChangeLifecycle) {
            this.canDeleteStepAndUnderStep = true;
            this.canCreateUnderStep = true;
        } else {
            this.canDeleteStepAndUnderStep = false;
            this.canCreateUnderStep = false;
        }
        this.canUpdateUnderStep = false;
    }

    public void loadAllLifecycles() throws LocalizedError {
        try {
            this.lifecycles = DragonServiceFactory.getInstance().getLifecycleManager().getAll();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void create() throws IError {
        this.lifecycle = new LifecycleTO();
        this.lifecycle.setName(this.name);
        try {
            this.id = DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpdateLifecycle(this.lifecycle);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create life cycle.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void save() throws IError {
        this.lifecycle = new LifecycleTO();
        this.lifecycle.setName(this.name);
        this.lifecycle.setId(this.id);
        try {
            this.id = DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpdateLifecycle(this.lifecycle);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't update life cycle.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        this.id = iRequest.getParameter("lifecycleId");
        try {
            DragonServiceFactory.getInstance().getLifecycleManager().deleteLifecycle(this.id);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't delete life cycle.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadAllLifecycles();
    }

    public boolean canChangeLifecycle(String idLifecycle) throws DragonDelegateException {
        this.id = idLifecycle;
        this.canChangeLifecycle = this.canChangeLifecycle();
        return this.canChangeLifecycle;
    }

    public boolean canChangeLifecycle() throws DragonDelegateException {
        this.canChangeLifecycle = DragonServiceFactory.getInstance().getLifecycleManager().canChangeLifecycle(this.id);
        return this.canChangeLifecycle;
    }

    public void addStep() throws IError {
        LifecycleStepTO lifecycleStep = new LifecycleStepTO();
        lifecycleStep.setName(this.stepName);
        int idx = this.listLifecycleStep == null || this.listLifecycleStep.size() == 0 ? 0 : this.listLifecycleStep.size();
        lifecycleStep.setIdx(idx);
        LifecycleTO l = new LifecycleTO();
        l.setId(this.id);
        lifecycleStep.setLifecycleTO(l);
        try {
            this.idStep = DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpadeLifecycleStep(lifecycleStep);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't add life cycle step.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.stepName = null;
        this.listUnderStep = new ArrayList();
        this.underStepName = null;
        this.visible = true;
    }

    public void updateStep(HttpServletRequest iRequest) throws IError {
        LifecycleStepTO lifecycleStep = new LifecycleStepTO();
        lifecycleStep.setId(this.idStep);
        lifecycleStep.setName(this.stepName);
        lifecycleStep.setListLifecycleUnderStep(this.listUnderStep);
        lifecycleStep.setIdx(this.idx);
        this.lifecycle = new LifecycleTO();
        this.lifecycle.setId(this.id);
        lifecycleStep.setLifecycleTO(this.lifecycle);
        try {
            this.idStep = DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpadeLifecycleStep(lifecycleStep);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't add life cycle step.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadStep();
        this.load();
    }

    public void deleteStep(HttpServletRequest iRequest) throws IError {
        this.idStep = iRequest.getParameter("idStep");
        this.idx = Integer.valueOf(iRequest.getParameter("idx"));
        for (LifecycleStepTO l : this.listLifecycleStep) {
            int idxTmp = l.getIdx();
            if (idxTmp <= this.idx) continue;
            l.setIdx(idxTmp - 1);
            try {
                DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpadeLifecycleStep(l);
            }
            catch (LifecycleException e) {
                NonLocalizedError error = new NonLocalizedError("Can't delete life cycle step.", e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            catch (Throwable e) {
                this.logger.error((Object)e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        try {
            DragonServiceFactory.getInstance().getLifecycleManager().deleteLifecycleStep(this.idStep);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't delete life cycle step.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.stepName = null;
        this.load();
    }

    public void getUpStep(HttpServletRequest iRequest) throws Exception {
        this.idStep = iRequest.getParameter("idStep");
        for (int j = 0; j < this.listLifecycleStep.size(); ++j) {
            LifecycleStepTO lifecycleStep = new LifecycleStepTO();
            lifecycleStep = (LifecycleStepTO)this.listLifecycleStep.get(j);
            this.idx = lifecycleStep.getIdx();
            if (!this.idStep.equals(lifecycleStep.getId()) || this.idx <= 0) continue;
            LifecycleStepTO lifecycleStepTmp = (LifecycleStepTO)this.listLifecycleStep.get(j - 1);
            int idxTmp = lifecycleStepTmp.getIdx();
            lifecycleStepTmp.setIdx(this.idx);
            lifecycleStep.setIdx(idxTmp);
            DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpadeLifecycleStep(lifecycleStepTmp);
            DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpadeLifecycleStep(lifecycleStep);
        }
        this.load();
    }

    public void getDownStep(HttpServletRequest iRequest) throws Exception {
        this.idStep = iRequest.getParameter("idStep");
        for (int j = 0; j < this.listLifecycleStep.size(); ++j) {
            LifecycleStepTO lifecycleStep = new LifecycleStepTO();
            lifecycleStep = (LifecycleStepTO)this.listLifecycleStep.get(j);
            this.idx = lifecycleStep.getIdx();
            if (!this.idStep.equals(lifecycleStep.getId()) || this.idx >= this.listLifecycleStep.size() - 1) continue;
            LifecycleStepTO lifecycleStepTmp = (LifecycleStepTO)this.listLifecycleStep.get(j + 1);
            int idxTmp = lifecycleStepTmp.getIdx();
            lifecycleStepTmp.setIdx(this.idx);
            lifecycleStep.setIdx(idxTmp);
            DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpadeLifecycleStep(lifecycleStepTmp);
            DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpadeLifecycleStep(lifecycleStep);
        }
        this.load();
    }

    public void addUnderStep() throws IError {
        LifecycleStepTO lifecycleStep = new LifecycleStepTO();
        lifecycleStep.setId(this.idStep);
        LifecycleUnderStepTO underStep = new LifecycleUnderStepTO();
        if (this.idUnderStep != null) {
            underStep.setId(this.idUnderStep);
        }
        underStep.setName(this.underStepName);
        underStep.setLifecycleStepTO(lifecycleStep);
        try {
            DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpdateUnderStep(underStep);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't add check point.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.listUnderStep.add(underStep);
        this.loadStep();
        this.underStepName = null;
    }

    public void updateUnderStep() throws NonLocalizedError, LocalizedError {
        LifecycleStepTO lifecycleStep = new LifecycleStepTO();
        lifecycleStep.setId(this.idStep);
        LifecycleUnderStepTO underStep = new LifecycleUnderStepTO();
        if (this.idUnderStep != null) {
            underStep.setId(this.idUnderStep);
        }
        underStep.setName(this.underStepName);
        underStep.setLifecycleStepTO(lifecycleStep);
        try {
            DragonServiceFactory.getInstance().getLifecycleManager().saveOrUpdateUnderStep(underStep);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't update check point.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadStep();
        this.underStepName = null;
    }

    public void viewEditUpdate(HttpServletRequest iRequest) throws NonLocalizedError, LocalizedError {
        this.idUnderStep = iRequest.getParameter("understepID");
        LifecycleUnderStepTO underStep = null;
        try {
            underStep = DragonServiceFactory.getInstance().getLifecycleManager().getUnderStep(this.idUnderStep);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't load check point.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.underStepName = underStep.getName();
        this.idUnderStep = underStep.getId();
        this.canCreateUnderStep = false;
        this.canUpdateUnderStep = true;
    }

    public void resetUnderStep() {
        this.underStepName = null;
        this.idUnderStep = null;
        this.canCreateUnderStep = true;
        this.canUpdateUnderStep = false;
    }

    public void removeUnderStepByName(HttpServletRequest iRequest) throws IError {
        String idUnderStep = iRequest.getParameter("understepID");
        try {
            DragonServiceFactory.getInstance().getLifecycleManager().deleteUnderStep(idUnderStep);
        }
        catch (LifecycleException e) {
            NonLocalizedError error = new NonLocalizedError("Can't remove check point.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadStep();
    }

    public void cancel() throws LocalizedError {
        this.stepName = null;
        this.listUnderStep = new ArrayList();
        this.underStepName = null;
        this.load();
    }

    public void clear() {
        this.name = null;
    }

    public void reset() {
    }

    public void validate() {
    }

    public void unlinkedServices(HttpServletRequest iRequest) throws DragonDelegateException, LifecycleException {
        this.id = iRequest.getParameter("lifecycleId");
        for (String idService : this.selectedServices) {
            DragonServiceFactory.getInstance().getLifecycleServiceManager().deleteByTechServiceId(idService);
        }
        this.listLinkedServices = DragonServiceFactory.getInstance().getLifecycleManager().getAllLinkedServices(this.id);
    }

    public void selectAllServices() {
        this.selectedServices = new String[this.listLinkedServices.size()];
        for (int i = 0; i < this.listLinkedServices.size(); ++i) {
            this.selectedServices[i] = ((TechnicalServiceTO)this.listLinkedServices.get(i)).getId();
        }
    }

    public void deselectAllServices() {
        this.selectedServices = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<LifecycleTO> getLifecycles() {
        return this.lifecycles;
    }

    public void setLifecycles(List<LifecycleTO> lifecycles) {
        this.lifecycles = lifecycles;
    }

    public LifecycleTO getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(LifecycleTO lifecycle) {
        this.lifecycle = lifecycle;
    }

    public String getIdStep() {
        return this.idStep;
    }

    public void setIdStep(String idStep) {
        this.idStep = idStep;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public List<LifecycleStepTO> getListLifecycleStep() {
        return this.listLifecycleStep;
    }

    public void setListLifecycleStep(List<LifecycleStepTO> listLifecycleStep) {
        this.listLifecycleStep = listLifecycleStep;
    }

    public String getUnderStepName() {
        return this.underStepName;
    }

    public void setUnderStepName(String underStepName) {
        this.underStepName = underStepName;
    }

    public List<LifecycleUnderStepTO> getListUnderStep() {
        return this.listUnderStep;
    }

    public void setListUnderStep(List<LifecycleUnderStepTO> listUnderStep) {
        this.listUnderStep = listUnderStep;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getIdUnderStep() {
        return this.idUnderStep;
    }

    public void setIdUnderStep(String idUnderStep) {
        this.idUnderStep = idUnderStep;
    }

    public boolean isCanChangeLifecycle() {
        return this.canChangeLifecycle;
    }

    public void setCanChangeLifecycle(boolean canChangeLifecycle) {
        this.canChangeLifecycle = canChangeLifecycle;
    }

    public boolean isCanCreateUnderStep() {
        return this.canCreateUnderStep;
    }

    public void setCanCreateUnderStep(boolean canCreateUnderStep) {
        this.canCreateUnderStep = canCreateUnderStep;
    }

    public boolean isCanUpdateUnderStep() {
        return this.canUpdateUnderStep;
    }

    public void setCanUpdateUnderStep(boolean canUpdateUnderStep) {
        this.canUpdateUnderStep = canUpdateUnderStep;
    }

    public List<TechnicalServiceTO> getListLinkedServices() {
        return this.listLinkedServices;
    }

    public void setListLinkedServices(List<TechnicalServiceTO> listLinkedServices) {
        this.listLinkedServices = listLinkedServices;
    }

    public String[] getSelectedServices() {
        return this.selectedServices;
    }

    public void setSelectedServices(String[] selectedServices) {
        this.selectedServices = selectedServices;
    }

    public boolean isCanDeleteStepAndUnderStep() {
        return this.canDeleteStepAndUnderStep;
    }

    public void setCanDeleteStepAndUnderStep(boolean canDeleteStepAndUnderStep) {
        this.canDeleteStepAndUnderStep = canDeleteStepAndUnderStep;
    }
}

