/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.organization.PostSearchProperties;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

public class ListOfPostsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<PostTO> posts;
    private List<PostTO> freePosts;
    private List<PostTO> orgPosts;
    private String searchCriteria;
    private List<String> searchedProperties;

    public void loadAll() throws LocalizedError {
        try {
            this.posts = DragonServiceFactory.getInstance().getPostManager().getAllPosts(this.createSortOption(SortCriteria.POST_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadByOrganization(String orgId) throws LocalizedError {
        try {
            this.posts = DragonServiceFactory.getInstance().getOrganizationManager().getPostsByOrganization(orgId, this.createSortOption(SortCriteria.POST_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void deletePost(String postId, HttpServletRequest request) throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getPostManager().removePost(postId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.search(request);
    }

    public String postInUse(PostTO post) throws LocalizedError {
        return post.isPostInUse() ? "yes" : "no";
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            List properties = this.convertSearchedProperties(searchedProperties);
            try {
                this.posts = DragonServiceFactory.getInstance().getPostManager().searchPost(searchCriteria, properties, this.createSortOption(SortCriteria.POST_NAME, true));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.posts == null || this.posts.size() == 0) {
                LocalizedError error = new LocalizedError("search_post_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    private List<PostSearchProperties> convertSearchedProperties(List<String> searchedProperties2) {
        ArrayList<PostSearchProperties> result = new ArrayList<PostSearchProperties>();
        for (String prop : searchedProperties2) {
            PostSearchProperties propEnum = PostSearchProperties.fromString((String)prop);
            if (propEnum == null) continue;
            result.add(propEnum);
        }
        return result;
    }

    public void loadFree(HttpServletRequest request) throws LocalizedError {
        String orgId = request.getParameter("organizationId");
        try {
            this.posts = DragonServiceFactory.getInstance().getPostManager().getPostsNotLinkedToOrganization(orgId, this.createSortOption(SortCriteria.POST_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public List<PostTO> getPostsToAdd() {
        ArrayList<PostTO> postsToAdd = new ArrayList();
        if (this.posts != null && !this.posts.isEmpty()) {
            postsToAdd = this.posts;
        } else {
            PostTO emptyPost = new PostTO();
            emptyPost.setId("");
            emptyPost.setName("No post to add");
            postsToAdd.add(emptyPost);
        }
        return postsToAdd;
    }

    public void noOrgSelected() {
        PostTO emptyPost = new PostTO();
        emptyPost.setName("Select an org first");
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        result.add(emptyPost);
        this.posts = result;
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public List<PostTO> getPosts() {
        return this.posts;
    }

    public List<PostTO> getFreePosts() {
        return this.freePosts;
    }

    public List<PostTO> getOrgPosts() {
        return this.orgPosts;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }
}

