/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.EndpointBean;
import org.ow2.opensuit.core.error.LocalizedError;

public class PersonToEndpointBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private PersonToEndpointTO role;
    private String[] personRoles;
    private String type;
    private String personId;
    private String endpointId;
    private String organizationId;

    public String addRoleToPerson(HttpServletRequest iRequest, EndpointBean endpointBean) throws LocalizedError {
        this.endpointId = iRequest.getParameter("endpointId");
        try {
            DragonServiceFactory.getInstance().getRoleOfPartyManager().createEndpointRole(this.personId, this.endpointId, this.type);
            endpointBean.loadPersonRoles();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void loadPersonRoles() throws LocalizedError {
        try {
            this.personRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getRolesTypes(RoleOfPartyManager.LINK_TYPE.PERSON_TO_ENDPOINT, null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void reset() {
        this.type = this.role.getType();
    }

    public void clear() {
        this.role = new PersonToEndpointTO();
        this.reset();
    }

    public String getId() {
        if (this.role == null) {
            return "";
        }
        return this.role.getId();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String[] getPersonRoles() {
        return this.personRoles;
    }

    public void setPersonRoles(String[] personRoles) {
        this.personRoles = personRoles;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }
}

