/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.technology.ExecEnvSearchProperties;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

public class ListOfExecutionEnvironmentsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<ExecutionEnvironmentTO> execEnvs;
    private String searchCriteria;
    private List<String> searchedProperties;

    public void loadAll() throws LocalizedError {
        try {
            this.execEnvs = DragonServiceFactory.getInstance().getTechnologyManager().getAllExecutionEnvironments(this.createSortOption(SortCriteria.EXEC_ENV_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            List properties = this.convertSearchedProperties(searchedProperties);
            try {
                this.execEnvs = DragonServiceFactory.getInstance().getTechnologyManager().searchExecutionEnvironments(searchCriteria, properties, this.createSortOption(SortCriteria.EXEC_ENV_NAME, true));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.execEnvs == null || this.execEnvs.size() == 0) {
                LocalizedError error = new LocalizedError("search_exec_env_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    private List<ExecEnvSearchProperties> convertSearchedProperties(List<String> searchedProperties2) {
        ArrayList<ExecEnvSearchProperties> result = new ArrayList<ExecEnvSearchProperties>();
        for (String prop : searchedProperties2) {
            ExecEnvSearchProperties propEnum = ExecEnvSearchProperties.fromString((String)prop);
            if (propEnum == null) continue;
            result.add(propEnum);
        }
        return result;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }

    public List<ExecutionEnvironmentTO> getExecEnvs() {
        return this.execEnvs;
    }

    public void setExecEnvs(List<ExecutionEnvironmentTO> execEnvs) {
        this.execEnvs = execEnvs;
    }
}

