/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

public class ProcessorBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private ProcessorTO processorTO;
    private List<ExecutionEnvironmentTO> hostedExecEnvs;
    private List<EndpointTO> hostedEps;
    private String processorId;
    private String name;
    private String ipv4Address;

    public String load(HttpServletRequest request) throws LocalizedError {
        String id = request.getParameter("processorId");
        this.loadProcessor(id);
        this.loadExecEnvs(id);
        this.loadHostedEps(id);
        this.reset();
        return "success";
    }

    private void loadExecEnvs(String id) throws LocalizedError {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        try {
            this.hostedExecEnvs = DragonServiceFactory.getInstance().getTechnologyManager().getExecEnvsHostedOnProcessor(id, requestOptionsTO);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    private void loadHostedEps(String id) throws LocalizedError {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.ENDPOINT_NAME);
        try {
            this.hostedEps = DragonServiceFactory.getInstance().getTechnologyManager().getEpsHostedOnProcessor(id, requestOptionsTO);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    private void loadProcessor(String id) throws LocalizedError {
        try {
            this.processorTO = DragonServiceFactory.getInstance().getTechnologyManager().getProcessor(id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void reset() {
        if (this.processorTO != null) {
            this.ipv4Address = this.processorTO.getIpv4Address();
            this.name = this.processorTO.getName();
            this.processorId = this.processorTO.getNodeId();
        }
    }

    public void save() {
    }

    public void validate() {
    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeProcessor(this.processorTO.getNodeId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public List<EndpointTO> getHostedEps() {
        return this.hostedEps;
    }

    public void setHostedEps(List<EndpointTO> hostedEps) {
        this.hostedEps = hostedEps;
    }

    public ProcessorTO getProcessorTO() {
        return this.processorTO;
    }

    public void setProcessorTO(ProcessorTO processorTO) {
        this.processorTO = processorTO;
    }

    public List<ExecutionEnvironmentTO> getHostedExecEnvs() {
        return this.hostedExecEnvs;
    }

    public void setHostedExecEnvs(List<ExecutionEnvironmentTO> hostedExecEnvs) {
        this.hostedExecEnvs = hostedExecEnvs;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }
}

