/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.utils.authent;

import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.administration.UserException;
import org.ow2.dragon.api.service.administration.UserManager;
import org.ow2.dragon.api.to.administration.RoleTO;
import org.ow2.dragon.api.to.administration.UserTO;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class MyUserDetailsService
implements UserDetailsService {
    private final Logger logger = Logger.getLogger(this.getClass());
    private UserManager userManager;

    public UserDetails loadUserByUsername(String login) {
        try {
            UserTO user = this.userManager.getUserByLogin(login);
            if (null == user) {
                this.logger.error((Object)("User with login : " + login + " not found in database."));
                throw new UsernameNotFoundException("user not found in database");
            }
            List roles = user.getListRoles();
            GrantedAuthority[] arrayAuths = new GrantedAuthority[roles.size() + 1];
            int i = 0;
            arrayAuths[i++] = new GrantedAuthorityImpl("ROLE_AUTH");
            for (RoleTO role : roles) {
                arrayAuths[i++] = new GrantedAuthorityImpl("ROLE_" + role.getName());
            }
            User springUser = new User(login, user.getPassword(), true, true, true, true, arrayAuths);
            return springUser;
        }
        catch (DataAccessException e) {
            throw new UsernameNotFoundException("Authentification failed for user " + login, (Throwable)e);
        }
        catch (UserException u) {
            this.logger.error((Object)u.getMessage(), (Throwable)u);
            throw new UsernameNotFoundException("Authentification failed for user " + login);
        }
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

