/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.springframework.util.ResourceUtils;

public class InputStreamUtil {
    private static final String FILE_SCHEME = "file";

    public static InputStream getInputStream(String resourceLocation) throws IOException, URISyntaxException {
        return InputStreamUtil.getInputStream(ResourceUtils.getURL((String)resourceLocation));
    }

    public static InputStream getInputStream(URI resourceLocation) throws IOException, URISyntaxException {
        return InputStreamUtil.getInputStream(ResourceUtils.getURL((String)resourceLocation.toString()));
    }

    public static InputStream getInputStream(URL resourceLocation) throws IOException, URISyntaxException {
        InputStream result = null;
        if (FILE_SCHEME.equals(resourceLocation.getProtocol())) {
            File f = new File(resourceLocation.toURI());
            result = new FileInputStream(f);
        } else {
            result = ResourceUtils.getURL((String)resourceLocation.toString()).openStream();
        }
        return result;
    }
}

