/**
 * 
 */

package org.ow2.petals.flowwatch.gui.beans;

import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;

/**
 * @author ofabre
 * 
 */
public class CreateFlowRef {

    private int type;

    private String name;

    public void init() {
        type = 0;
        name = null;
    }

    public String create() throws Exception {
        try {
            FlowRefManager.getInstance().createFlowRef(type, name);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        }
        // refresh ReferentialBean
        ReferentialBean.reload();
        return "success";
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
