
package org.ow2.petals.flowwatch.gui.beans;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.FlowParamsDetails;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStep;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;

public class FlowDetails {
    private Flow flow;

    private List<FlowStep> steps;

    private FlowRef flowRef;

    private FlowManager flowManager = FlowManager.getInstance();

    private FlowRefManager flowRefManager = FlowRefManager.getInstance();

    private List<FlowParamsDetails> listFlowParamsDetails = new ArrayList<FlowParamsDetails>();

    FlowStepRef flowStepRef = new FlowStepRef();

    public void load(HttpServletRequest request) {
        String id = request.getParameter("id");
        flow = flowManager.load(id);
        if (flow.getStatus() == null) {
            flow.setStatus(-1);
        }
        steps = flowManager.loadSteps(id);
        listFlowParamsDetails = flowRefManager.getDetailFlowParameter((short) flow.getType(), id);
    }

    public void refresh() {
        flow = flowManager.load(flow.getIdpetals());
        if (flow.getStatus() == null) {
            flow.setStatus(-1);
        }
        steps = flowManager.loadSteps(flow.getIdpetals());
        listFlowParamsDetails = flowRefManager.getDetailFlowParameter((short) flow.getType(), flow
                .getIdpetals());
    }

    public Flow getFlow() {
        return flow;
    }

    public Flow[] getFlows() {
        return new Flow[] { flow };
    }

    public List<FlowStep> getSteps() {
        return steps;
    }

    public FlowRef getFlowRef() {
        return flowRef;
    }

    public String getFlowType() {
        String result = "Undefined flow type";
        if (flowRef != null) {
            result = flowRef.getName();
        }
        return result;
    }

    public List<FlowParamsDetails> getListFlowParamsDetails() {
        return listFlowParamsDetails;
    }

    public String getShortStepName(FlowStep step) {
        String result = "";
        flowStepRef = flowRefManager.loadStepRef(flow.getType(), step.getInterfaceName(), step
                .getServiceName());
        // If a flow ref is defined, we could use an explicit step name*/
        if (flowStepRef != null) {
            result = flowStepRef.getName();
            if (result.length() > 30) {
                result = result.substring(0, 27) + "...";
            }
        } else {
            // By default, a step name is a concatenation of the interface name
            // and service name
            result = step.getInterfaceName() + "/" + step.getServiceName();
            if (result.length() > 30) {
                String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart()
                        .length() > 11 ? QName.valueOf(step.getInterfaceName()).getLocalPart()
                        .substring(0, 10)
                        + "..." : QName.valueOf(step.getInterfaceName()).getLocalPart();
                String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 11 ? QName
                        .valueOf(step.getServiceName()).getLocalPart().substring(0, 10)
                        + "..."
                        : QName.valueOf(step.getServiceName()).getLocalPart();
                result = shortIntName + "/" + shortServName;
            }
        }

        return result;
    }

    public String getStepName(FlowStep step) {
        String result = "";
        // If a flow ref is defined, we could use an explicit step name
        if (flowStepRef != null) {
            result = flowStepRef.getName();
        } else {
            // By default, a step name is a concatenation of the interface name
            // and service name
            result = step.getInterfaceName() + "/" + step.getServiceName();
        }
        return result;
    }

    public String getStepKey(FlowStep step) {
        return step.getInterfaceName() + "/" + step.getServiceName() + "/" + step.getEndpointName()
                + "/" + step.getMeUUID();
    }

    /**
     * Convert a flow status into a ui status (in_progress = 2, success = 0,
     * failure = 1)
     * 
     * @param status
     * @return
     */
    public int getUiStatus(int status) {
        if (status == Flow.SUCCESS_STATUS)
            return 0;
        else if (status == Flow.IN_PROGRESS_STATUS)
            return 2;
        else
            return 1;
    }

    public String getStepMessage(FlowStep step) {
        String result = "No messages defined for this step";
        // Retrieve the corresponding step ref
        FlowStepRef flowStepRef = flowRefManager.loadStepRef(flow.getType(), step
                .getInterfaceName(), step.getServiceName());
        if (flowStepRef != null) {
            if (step.getStatus() == Flow.SUCCESS_STATUS) {
                result = flowStepRef.getSuccessMessage();
            } else if (step.getStatus() == Flow.IN_PROGRESS_STATUS) {
                result = null;
            } else {
                // --- cas d'erreur
                FlowStepErrorRef error = flowStepRef.getErrorMessages().get(step.getStatus());
                if (error == null) {
                    // --- error code not registered
                    result = flowStepRef.getDefaultErrorMessage() != null ? flowStepRef
                            .getDefaultErrorMessage() : "Error " + step.getStatus() + " (?)";
                } else {
                    result = error.getMessage();
                }
            }
        }
        return result;
    }

}
