
package org.ow2.petals.flowwatch.gui.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;
import org.ow2.petals.flowwatch.flowmanager.bo.StepParameter;

public class FlowReferential {
    private FlowRef flowRef;

    private List<FlowStepRef> stepRefs;

    private long[] selectedSteps;

    // ===========================================================
    // === Control Methods
    // ===========================================================
    public void load(HttpServletRequest request) {
        int type = Integer.parseInt(request.getParameter("type"));
        loadFlowRef(type);
        loadStepRefs(type);
    }

    private void loadFlowRef(int type) {
        flowRef = FlowRefManager.getInstance().getFlowRef(type);
    }

    private void loadStepRefs(int type) {
        stepRefs = FlowRefManager.getInstance().loadSteps(type);
        selectedSteps = new long[0];
    }

    // --- Steps Management Methods
    public void removeStepRefs() {
        FlowRefManager.getInstance().removeStepRefs(selectedSteps);
        loadStepRefs(flowRef.getType());
    }

    // ===========================================================
    // === Getters/Setters
    // ===========================================================
    public FlowRef getFlowRef() {
        return flowRef;
    }

    public List<FlowStepRef> getStepRefs() {
        return stepRefs;
    }

    public long[] getSelectedSteps() {
        return selectedSteps;
    }

    public void setSelectedSteps(long[] selectedSteps) {
        this.selectedSteps = selectedSteps;
    }

    // ===========================================================
    // --- Helper Methods for GUI
    // ===========================================================
    public String buildErrorMessagesHtml(FlowStepRef step) {
        Map<Integer, FlowStepErrorRef> errorMessages = step.getErrorMessages();
        String defaultErrorMessage = step.getDefaultErrorMessage();
        if ((defaultErrorMessage == null || "".equals(defaultErrorMessage))
                && (errorMessages == null || errorMessages.size() == 0))
            return null;
        Collection<FlowStepErrorRef> errors = errorMessages.values();
        StringBuffer sb = new StringBuffer();
        sb.append("\\html\\");
        sb.append("<ul class=list>\n");
        for (FlowStepErrorRef error : errors) {
            sb.append("<li>");
            sb.append(String.valueOf(error.getErrorCode()));
            sb.append(": ");
            sb.append(error.getMessage());
            sb.append("</li>\n");
        }
        if (defaultErrorMessage != null || !("".equals(defaultErrorMessage))) {
            sb.append("<li>");
            sb.append("default");
            sb.append(": ");
            sb.append(defaultErrorMessage);
            sb.append("</li>\n");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public String getShortStepKey(FlowStepRef step) {
        String result = step.getInterfaceName() + "/" + step.getServiceName();
        if (result.length() > 50) {
            String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart().length() > 21 ? QName
                    .valueOf(step.getInterfaceName()).getLocalPart().substring(0, 20)
                    + "..."
                    : QName.valueOf(step.getInterfaceName()).getLocalPart();
            String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 21 ? QName
                    .valueOf(step.getServiceName()).getLocalPart().substring(0, 20)
                    + "..."
                    : QName.valueOf(step.getServiceName()).getLocalPart();
            result = shortIntName + "/" + shortServName;
        }
        return result;
    }

    public String getStepName(FlowStepRef step) {
        return step.getName();
    }

    public String getShortStepName(FlowStepRef step) {
        String result = "";
        if (step.getName().length() > 50) {
            result = step.getName().substring(0, 46) + "...";
        } else {
            result = step.getName();
        }
        return result;
    }

    public String getStepKey(FlowStepRef step) {
        return step.getInterfaceName() + "/" + step.getServiceName();
    }

    public List<FlowRefParameter> getFlowParameters() {
        List<FlowRefParameter> result = new ArrayList<FlowRefParameter>();
        if (stepRefs != null) {
            for (FlowStepRef stepRef : stepRefs) {
                if (stepRef.getParameterNames() != null) {
                    for (StepParameter stepParameter : stepRef.getParameterNames()) {
                        if (stepParameter.isGlobal()) {
                            result.add(new FlowRefParameter(stepParameter, stepRef));
                        }
                    }
                }
            }
        }
        return result;
    }

    public class FlowRefParameter {
        private StepParameter parameter;

        private FlowStepRef stepRef;

        public StepParameter getParameter() {
            return parameter;
        }

        public void setParameter(StepParameter parameter) {
            this.parameter = parameter;
        }

        public FlowStepRef getStepRef() {
            return stepRef;
        }

        public void setStepRef(FlowStepRef stepRef) {
            this.stepRef = stepRef;
        }

        public FlowRefParameter() {
            super();
        }

        public FlowRefParameter(StepParameter parameter, FlowStepRef stepRef) {
            super();
            this.parameter = parameter;
            this.stepRef = stepRef;
        }

    }
}
