
package org.ow2.petals.flowwatch.gui.beans;

import java.util.List;

import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;

public class ListOfFlowRefs {

    private List<FlowRef> flowRefs;

    private int[] selection;

    // ===============================================================
    // === control methods
    // ===============================================================
    public void loadAll() {
        flowRefs = FlowRefManager.getInstance().loadAll();
    }

    public String deleteSelected() throws Exception {
        FlowRefManager.getInstance().removeFlowRef(selection);
        // then reload
        loadAll();
        // refresh ReferentialBean
        ReferentialBean.reload();
        return "success";
    }

    // ===============================================================
    // === setters/getters
    // ===============================================================
    public List<FlowRef> getFlowRefs() {
        return flowRefs;
    }

    public int[] getSelection() {
        return selection;
    }

    public void setSelection(int[] selection) {
        this.selection = selection;
    }
}
