
package org.ow2.petals.flowwatch.gui.beans;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.table.ITableRenderingContext;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.util.CSVExport;
import org.ow2.petals.flowwatch.util.OpenSuitTableHelper;

public class ListOfFlows {
    private static int[] ALL_STATUS = { 0 /* success */, 1 /* error */, 2 /*
                                                                           * in
                                                                           * progress
                                                                           */};

    private List<Flow> flows;

    private Date before;

    private Date after;

    private int rowCount;

    private TableRenderingContext ctx;

    private String fileUrl;

    private String fileName;

    // private RequestOptions requestOptions;

    // ===============================================================
    // === control methods
    // ===============================================================
    public void loadAll() {
        setupFilterToday();
    }

    private void setupFilterToday() {
        // --- initialize date filter to today
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        after = cal.getTime();
        cal.add(Calendar.DATE, 1);
        before = cal.getTime();
    }

    public String getShortName(Flow flow) {

        String shortName = flow.getIdpetals();

        if (shortName != null) {

            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {

            shortName = " ";
        }

        return shortName;
    }

    public String getName(Flow flow) {

        String name = flow.getIdpetals();
        return name;

    }

    /*
     * public void resetFilter() { after = null; before = null; }
     */

    public void viewAllFlow() {
        after = null;
        before = null;
    }

    public void validateFilter() throws ValidationErrors {
        // System.out.println("--> validate");
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();

        if (after != null && after.after(now)) {
            // System.out.println("--> future");
            errors.addItemError("flows.after", new LocalizedValidationError(
                    "validation.date.future"));
        }

        if (before != null && after != null && after.after(before)) {
            // System.out.println("--> negative range");
            errors.addItemError("flows.before", new LocalizedValidationError(
                    "validation.date.negative_range"));
        }

        if (errors.hasErrors()) {
            // System.out.println("--> throw");
            throw errors;
        }
    }

    public void refresh() {
        if (after == null && before == null) {
            viewAllFlow();
        } else {
            setupFilterToday();
        }
    }

    public void exportFlows(HttpServletRequest request, HttpServletResponse response,
            String nbOfResultStg) throws Exception {
        CSVExport csv = new CSVExport();
        int nbOfResult = 0;
        try {
            nbOfResult = Integer.valueOf(nbOfResultStg);
        } catch (Exception e) {
            e.printStackTrace();
        }

        csv.exportFlows(request, response, ctx, after, before, rowCount, nbOfResult);
    }

    // ===============================================================
    // === setters/getters
    // ===============================================================

    public List<Flow> getFlows() throws Exception {

        // Retrieve the flow table rendering context that handle first index,
        // row per page, sort info, row count and filter
        ctx = (TableRenderingContext) ITableRenderingContext.get(OpenSuitSession
                .getCurrentRequest());

        if (ctx != null) {
            // Create request options from this context
            RequestOptions requestOptions = OpenSuitTableHelper.createRequestOption(ctx);

            rowCount = FlowManager.getInstance().countAllFlows(after, before, requestOptions);
            ctx.setRowsCount(rowCount);
            if(rowCount !=0){
                this.flows = FlowManager.getInstance().getAllFlows(after, before, requestOptions);

                return flows;
            }else {
                return null;
            }
            
        } else {
            return null;
        }
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    public Date getBefore() {
        return before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * Convert a flow status into a ui status (in_progress = 2, success = 0,
     * failure = 1)
     * 
     * @param status
     * @return
     */
    public int getUiStatus(int status) {
        if (status == Flow.SUCCESS_STATUS)
            return 0;
        else if (status == Flow.IN_PROGRESS_STATUS)
            return 2;
        else
            return 1;
    }

}
