
package org.ow2.petals.flowwatch.gui.beans;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.table.ITableRenderingContext;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.util.CSVExport;
import org.ow2.petals.flowwatch.util.OpenSuitTableHelper;

public class ListOfFlowsByType {
    private static int[] ALL_STATUS = { 0 /* success */, 1 /* error */, 2 /*
                                                                           * in
                                                                           * progress
                                                                           */};

    private int type = -1;

    private int[] paramIndex;

    private Date before;

    private Date after;

    private List<GlobalFlowParam> listGlobalFlowParam;

    private List<FlowWithParams> listFlowWithParams;

    // private RequestOptions requestOptions;
    private int rowCount;

    private TableRenderingContext ctx;

    public void loadByType(HttpServletRequest request) {
        type = Integer.parseInt(request.getParameter("type"));
        // resetFilter();
        setupFilterToday();

        listGlobalFlowParam = FlowRefManager.getInstance().getGlobalFlowParameters((short) type);
        paramIndex = new int[listGlobalFlowParam.size()];

        for (int i = 0; i < paramIndex.length; i++) {
            paramIndex[i] = i;
        }
    }

    private void setupFilterToday() {
        // --- initialize date filter to today
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        after = cal.getTime();
        cal.add(Calendar.DATE, 1);
        before = cal.getTime();
    }

    public String getFlowParameterName(int numIndex) {
        String name = listGlobalFlowParam.get(numIndex).getName();

        return name;
    }

    public String getShortName(FlowWithParams flowWithParams) {

        String shortName = flowWithParams.getIdpetals();

        if (shortName != null) {

            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {

            shortName = " ";
        }

        return shortName;
    }

    public String getName(FlowWithParams flowWithParams) {

        String name = flowWithParams.getIdpetals();
        return name;

    }

    public void viewAllFlow() {
        after = null;
        before = null;
    }

    public void validateFilter() throws ValidationErrors {
        // System.out.println("--> validate");
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();

        if (after != null && after.after(now)) {
            // System.out.println("--> future");
            errors.addItemError("flows.after", new LocalizedValidationError(
                    "validation.date.future"));
        }

        if (before != null && after != null && after.after(before)) {
            // System.out.println("--> negative range");
            errors.addItemError("flows.before", new LocalizedValidationError(
                    "validation.date.negative_range"));
        }

        if (errors.hasErrors()) {
            // System.out.println("--> throw");
            throw errors;
        }
    }

    public void applyFilterByType() {

    }

    public void refresh() {
        if (after == null && before == null) {
            viewAllFlow();
        } else {
            setupFilterToday();
        }
    }

    public void exportFlows(HttpServletRequest request, HttpServletResponse response,
            String nbOfResultStg) throws Exception {
        CSVExport csv = new CSVExport();
        int nbOfResult = 0;
        try {
            nbOfResult = Integer.valueOf(nbOfResultStg);
        } catch (Exception e) {
            e.printStackTrace();
        }
        csv.exportFlowsByType(request, response, ctx, after, before, listGlobalFlowParam,
                (short) type, rowCount, nbOfResult);
    }

    // ===============================================================
    // === setters/getters
    // ===============================================================
    public int[] getParamIndex() {
        return paramIndex;
    }

    public List<FlowWithParams> getFlowsWithParams() throws Exception {

        // Retrieve the flow table rendering context that handle first index,
        // row per page, sort info, row count and filter
        ctx = (TableRenderingContext) ITableRenderingContext.get(OpenSuitSession
                .getCurrentRequest());

        if (ctx != null) {
            // Create request options from this context
            RequestOptions requestOptions = OpenSuitTableHelper.createRequestOption(ctx);

            rowCount = FlowManager.getInstance().countAllFlowsByType(after, before,
                    listGlobalFlowParam, (short) type, requestOptions);
            ctx.setRowsCount(rowCount);
            if(rowCount !=0){
                this.listFlowWithParams = FlowManager.getInstance().getAllFlowsByType(after, before,
                        listGlobalFlowParam, (short) type, requestOptions);

                return listFlowWithParams;
            }else {
                return null;
            }       
        } else {
            return null;
        }
    }

    public Date getBefore() {
        return before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    /**
     * Convert a flow status into a ui status (in_progress = 2, success = 0,
     * failure = 1)
     * 
     * @param status
     * @return
     */
    public int getUiStatus(int status) {
        if (status == Flow.SUCCESS_STATUS)
            return 0;
        else if (status == Flow.IN_PROGRESS_STATUS)
            return 2;
        else
            return 1;
    }

}
