
package org.ow2.petals.flowwatch.gui.beans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.BeanUtils;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;

public class ReferentialBean {
    private List<FlowRef> flowRefs;

    private Map<Integer, FlowRef> typeToRef;

    public static void reload() throws Exception {
        ((ReferentialBean) BeanUtils.getOpenSuitBean(OpenSuitSession.getCurrentRequest(),
                "referential")).load();
    }

    public ReferentialBean() {
        load();
    }

    private void load() {
        flowRefs = FlowRefManager.getInstance().loadAll();
        typeToRef = new HashMap<Integer, FlowRef>();
        for (FlowRef fr : flowRefs)
            typeToRef.put(fr.getType(), fr);
    }

    public List<FlowRef> getAllFlows() {
        return flowRefs;
    }

    public FlowRef getFlowRef(int type) {
        return typeToRef.get(type);
    }

    public String getFlowRefName(int type) {
        String result = "Unknown";
        FlowRef flowRef = typeToRef.get(type);
        if (flowRef != null) {
            result = flowRef.getName();
        }
        return result;
    }

    public String getFlowRefName(HttpServletRequest request) {
        String result = "Unknown";
        int type = Integer.parseInt(request.getParameter("type"));
        FlowRef flowRef = typeToRef.get(type);
        if (flowRef != null) {
            result = flowRef.getName();
        }

        return result;
    }
}
