/**
 * 
 */

package org.ow2.petals.flowwatch.gui.beans;

import javax.servlet.http.HttpServletRequest;

import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;

/**
 * @author ofabre
 * 
 */
public class StepErrorRefDetails {

    private int errorCode;

    private String errorMessage;

    private FlowStepErrorRef stepErrorRef;

    private long stepRefId;

    public FlowStepErrorRef getStepErrorRef() {
        return stepErrorRef;
    }

    public void setStepErrorRef(FlowStepErrorRef stepErrorRef) {
        this.stepErrorRef = stepErrorRef;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void load(HttpServletRequest request) {
        long id = Long.parseLong(request.getParameter("id"));
        init(request);
        loadStepErrorRef(id);
    }

    public void init(HttpServletRequest request) {
        stepRefId = Long.parseLong(request.getParameter("stepRefId"));
    }

    private void loadStepErrorRef(long id) {
        stepErrorRef = FlowRefManager.getInstance().loadStepErrorRef(id);
        reset();
    }

    public void reset() {
        errorCode = stepErrorRef.getErrorCode();
        errorMessage = stepErrorRef.getMessage();
    }

    public String create() throws LocalizedError {
        FlowStepErrorRef stepErrorRef = new FlowStepErrorRef();
        stepErrorRef.setErrorCode(errorCode);
        stepErrorRef.setMessage(errorMessage);
        stepErrorRef.setFlowStepRef(FlowRefManager.getInstance().loadStepRef(stepRefId));
        try {
            FlowRefManager.getInstance().saveOrUpdateErrorRef(stepErrorRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowsteperrorref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        }

        return "success";
    }

    public String update() throws LocalizedError {
        stepErrorRef.setErrorCode(errorCode);
        stepErrorRef.setMessage(errorMessage);
        try {
            FlowRefManager.getInstance().saveOrUpdateErrorRef(stepErrorRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowsteperrorref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        }
        return "success";
    }

}
