/**
 * 
 */

package org.ow2.petals.flowwatch.gui.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManagerRuntimeException;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;

/**
 * @author ofabre
 * 
 */
public class StepRefDetails {

    private String interfaceName;

    private String serviceName;

    private String functionalName;

    private boolean startStep = false;

    private boolean endStep = false;

    private String successMessage;

    private String defaultErrorMessage;

    private int flowRefType;

    private FlowStepRef flowStepRef;

    private long[] selectedErrorIds;

    private int[] selectedParamIndexes;

    private int[] paramIndex;

    // ===========================================================
    // === Control Methods
    // ===========================================================
    public void load(HttpServletRequest request) {
        long id = Long.parseLong(request.getParameter("id"));
        flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
        loadStepRef(id);
        paramIndex = new int[flowStepRef.getParameterNames().size()];
        for (int i = 0; i < paramIndex.length; i++)
            paramIndex[i] = i;
    }

    private void loadFlowParams(long id) {
        flowStepRef = FlowRefManager.getInstance().loadStepRef(id);
        selectedParamIndexes = new int[0];
    }

    public void init(HttpServletRequest request) {
        flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
    }

    private void loadStepRef(long id) {
        flowStepRef = FlowRefManager.getInstance().loadStepRef(id);
        reset();
    }

    public void reset() {
        interfaceName = flowStepRef.getInterfaceName();
        serviceName = flowStepRef.getServiceName();
        functionalName = flowStepRef.getName();
        startStep = flowStepRef.isFlowStartStep();
        endStep = flowStepRef.isFlowEndStep();
        successMessage = flowStepRef.getSuccessMessage();
        defaultErrorMessage = flowStepRef.getDefaultErrorMessage();
        selectedErrorIds = new long[0];
    }

    public String create() throws LocalizedError {
        FlowStepRef flowStepRef = new FlowStepRef();
        flowStepRef.setFlowEndStep(endStep);
        flowStepRef.setFlowref(FlowRefManager.getInstance().getFlowRef(flowRefType));
        flowStepRef.setFlowStartStep(startStep);
        flowStepRef.setInterfaceName(interfaceName);
        flowStepRef.setName(functionalName);
        flowStepRef.setServiceName(serviceName);
        flowStepRef.setSuccessMessage(successMessage);
        flowStepRef.setDefaultErrorMessage(defaultErrorMessage);
        try {
            FlowRefManager.getInstance().saveOrUpdateStepRef(flowStepRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        } catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        }
        return "success";
    }

    public String update() throws LocalizedError {
        flowStepRef.setFlowEndStep(endStep);
        flowStepRef.setFlowStartStep(startStep);
        flowStepRef.setInterfaceName(interfaceName);
        flowStepRef.setName(functionalName);
        flowStepRef.setServiceName(serviceName);
        flowStepRef.setSuccessMessage(successMessage);
        flowStepRef.setDefaultErrorMessage(defaultErrorMessage);
        try {
            FlowRefManager.getInstance().saveOrUpdateStepRef(flowStepRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        } catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        }
        return "success";
    }

    public String removeErrorRefs() {
        FlowRefManager.getInstance().removeErrorRefs(selectedErrorIds);
        loadStepRef(flowStepRef.getId());
        return "success";
    }

    public int[] makeIndexes(int size) {
        int[] ret = new int[size];
        for (int i = 0; i < ret.length; i++)
            ret[i] = i;
        return ret;
    }

    // --- Parameter Names Management Methods
    public String addParameterName(int index, String name, boolean global) {
        FlowRefManager.getInstance().addParameterName(flowStepRef.getId(), index, name, global);
        loadFlowParams(flowStepRef.getId());
        return "success";
    }

    public String updateParameterName(int index, String name, boolean global) {
        FlowRefManager.getInstance().updateParameterName(flowStepRef.getId(), index, name, global);
        loadFlowParams(flowStepRef.getId());
        return "success";
    }

    public String removeParameterNames() {
        FlowRefManager.getInstance()
                .removeParameterNames(flowStepRef.getId(), selectedParamIndexes);
        loadFlowParams(flowStepRef.getId());
        return "success";
    }

    // ===========================================================
    // === Getters/Setters
    // ===========================================================
    public String getInterfaceName() {
        return interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public int[] getParamIndex() {
        return paramIndex;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getFunctionalName() {
        return functionalName;
    }

    public void setFunctionalName(String functionalName) {
        this.functionalName = functionalName;
    }

    public boolean isStartStep() {
        return startStep;
    }

    public void setStartStep(boolean startStep) {
        this.startStep = startStep;
    }

    public boolean isEndStep() {
        return endStep;
    }

    public void setEndStep(boolean endStep) {
        this.endStep = endStep;
    }

    public String getSuccessMessage() {
        return successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public FlowStepRef getFlowStepRef() {
        return flowStepRef;
    }

    public void setFlowStepRef(FlowStepRef flowStepRef) {
        this.flowStepRef = flowStepRef;
    }

    public int getFlowRefType() {
        return flowRefType;
    }

    public void setFlowRefType(int flowRefType) {
        this.flowRefType = flowRefType;
    }

    public long[] getSelectedErrorIds() {
        return selectedErrorIds;
    }

    public void setSelectedErrorIds(long[] selectedErrorIds) {
        this.selectedErrorIds = selectedErrorIds;
    }

    public Collection<FlowStepErrorRef> getErrorMessages() {
        List<FlowStepErrorRef> flowErrorStepRefs = null;
        if (!(flowStepRef.getErrorMessages() == null || flowStepRef.getErrorMessages().size() == 0)) {
            flowErrorStepRefs = new ArrayList<FlowStepErrorRef>();
            flowErrorStepRefs.addAll(flowStepRef.getErrorMessages().values());
            Collections.sort(flowErrorStepRefs);
        }
        return flowErrorStepRefs;
    }

    public String getDefaultErrorMessage() {
        return defaultErrorMessage;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public int[] getSelectedParamIndexes() {
        return selectedParamIndexes;
    }

    public void setSelectedParamIndexes(int[] selectedParamIndexes) {
        this.selectedParamIndexes = selectedParamIndexes;
    }

}
