
package org.ow2.petals.flowwatch.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Calendar;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext.ColumnDef;
import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;

public class CSVExport {

    private String separator = ";";

    public void exportFlowsByType(HttpServletRequest iRequest, HttpServletResponse iResponse,
            TableRenderingContext context, Date after, Date before,
            List<GlobalFlowParam> listGlobalFlowParam, short type, int rowCount, int nbOfResult)
            throws Exception {

        // set the differents informations into the response
        setResponseInfo(iRequest, iResponse);

        // Printer instanciation
        PrintWriter printer = iResponse.getWriter();

        // Create column header information for the csv
        createColumnHeaderTitle(iRequest, context, printer);

        // Create the request options necessary
        RequestOptions requestOptions = createRequestOptions(context, nbOfResult);

        int firstIndex = 0;
        try {
            while (rowCount > 0) {
                requestOptions.setFirstResult(firstIndex);

                // Load flows by the request options
                List<FlowWithParams> flows = FlowManager.getInstance().getAllFlowsByType(after,
                        before, listGlobalFlowParam, type, requestOptions);

                // Create column values corresponding of flows
                createColumnValues(iRequest, context, printer, flows);

                firstIndex = firstIndex + requestOptions.getNbOfResults();
                rowCount = rowCount - requestOptions.getNbOfResults();

            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {

            if (printer != null) {
                printer.close();
            }
        }

    }

    public void exportFlows(HttpServletRequest iRequest, HttpServletResponse iResponse,
            TableRenderingContext context, Date after, Date before, int rowCount, int nbOfResult)
            throws Exception {

        // set the differents informations into the response
        setResponseInfo(iRequest, iResponse);

        // Printer instanciation
        PrintWriter printer = iResponse.getWriter();

        // Create column header information for the csv
        createColumnHeaderTitle(iRequest, context, printer);

        // Create the request options necessary
        RequestOptions requestOptions = createRequestOptions(context, nbOfResult);

        int firstIndex = 0;
        try {
            while (rowCount > 0) {
                requestOptions.setFirstResult(firstIndex);

                // Load flows by the request options
                List<Flow> flows = FlowManager.getInstance().getAllFlows(after, before,
                        requestOptions);

                // Create column values corresponding of flows
                createColumnValues(iRequest, context, printer, flows);

                firstIndex = firstIndex + requestOptions.getNbOfResults();
                rowCount = rowCount - requestOptions.getNbOfResults();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {

            if (printer != null) {
                printer.close();
            }
        }

    }

    private RequestOptions createRequestOptions(TableRenderingContext context, int nbOfResult)
            throws Exception {
        RequestOptions requestOptions = OpenSuitTableHelper.createRequestOption(context);

        requestOptions.setNbOfResults(nbOfResult);
        return requestOptions;
    }

    private void createColumnValues(HttpServletRequest iRequest, TableRenderingContext context,
            PrintWriter printer, List<?> flows) throws Exception, IOException {
        int iDisplayedCol;
        if (flows != null && !flows.isEmpty()) {
            for (Object rowObj : flows) {
                // --- place item in request
                iRequest.setAttribute(context.getTable().getRowBeanName(), rowObj);

                iDisplayedCol = 0;
                for (ColumnDef col : context.getColumns()) {
                    if (!col.isVisible()) {
                        continue;
                    }
                    // --- render cell
                    if (iDisplayedCol > 0) {
                        printer.print(separator);
                    }

                    Object cellData = col.getProvider().getCellDisplayedContent(iRequest, col,
                            rowObj);

                    String cellTest = String.valueOf(cellData);
                    String[] params = cellTest.split("<");

                    String[] myCurrParam = null;
                    for (int i = 0; i < params.length; i++) {
                        myCurrParam = params[i].split(">");
                        for (int j = 0; j < myCurrParam.length; j++) {
                            if (j == 1 && i == 1) {
                                cellData = myCurrParam[1];
                            }
                        }
                    }

                    write2CSV(printer, cellData);
                    iDisplayedCol++;
                }
                printer.print('\n');
            }
            printer.flush();
        }
    }

    private void createColumnHeaderTitle(HttpServletRequest iRequest,
            TableRenderingContext context, PrintWriter printer) throws IOException, Exception {
        int iDisplayedCol = 0;
        for (ColumnDef col : context.getColumns()) {
            if (!col.isVisible()) {
                continue;
            }
            if (iDisplayedCol > 0) {
                printer.print(separator);
            }

            write2CSV(printer, col.getProvider().getColumnTitle(iRequest, col));
            iDisplayedCol++;
        }
        printer.print('\n');
    }

    private void setResponseInfo(HttpServletRequest iRequest, HttpServletResponse iResponse) {
        OpenSuitSession session = OpenSuitSession.getSession(iRequest);
        // --- render response (CSV)
        iResponse.setContentType("text/petlasviewexport" + ";charset="
                + session.getLocaleConfig().getCharSet());
        iResponse.setHeader("Cache-Control", "no-cache"); // HTTP 1.1
        iResponse.setHeader("Pragma", "no-cache"); // HTTP 1.0

        iResponse.setDateHeader("Expires", 0); // prevents caching at the proxy
    }

    private static void write2CSV(PrintWriter writer, Object value) throws IOException {
        if (value == null)
            // write nothing
            return;

        if (value.getClass() == Boolean.class || value.getClass() == Boolean.TYPE) {
            writer.print(String.valueOf(value));
        } else if (Number.class.isInstance(value)) {
            writer.print(String.valueOf(value));
        } else if (value.getClass().isPrimitive()) {
            writer.print(String.valueOf(value));
        } else if (Date.class.isInstance(value) || Calendar.class.isInstance(value)) {

            writer.print(String.valueOf(value));
        } else {
            // --- output to string (surround with double-quotes)
            String text = String.valueOf(value);
            int nbChars = text.length();
            writer.write('\"');
            for (int i = 0; i < nbChars; i++) {
                char c = text.charAt(i);
                switch (c) {
                    case '"': // escape double quotes
                        writer.print("\"\"");
                        break;
                    default:
                        writer.write(c);
                        break;
                }
            }
            writer.write('\"');
        }
    }
}
