/**
 * 
 */

package org.ow2.petals.flowwatch.util;

import java.lang.reflect.Field;

import org.hibernate.util.StringHelper;
import org.ow2.opensuit.xml.base.html.table.ComboFilter;
import org.ow2.opensuit.xml.base.html.table.IFilter;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.opensuit.xml.base.html.table.TextFilter;
import org.ow2.opensuit.xml.base.html.table.filter.Equals;
import org.ow2.petals.flowwatch.flowmanager.Filter;
import org.ow2.petals.flowwatch.flowmanager.Filter.FilterType;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;

/**
 * @author ofabre
 * 
 */
public class OpenSuitTableHelper {

    public static RequestOptions createRequestOption(TableRenderingContext ctx) throws Exception {
        RequestOptions requestOptions = new RequestOptions();

        // Retrieve pagination options
        requestOptions.setFirstResult(ctx.getFirstIndex());
        requestOptions.setNbOfResults(ctx.getRowsPerPage());

        // Retrieve sort options
        requestOptions.setSortAscendingly(ctx.getSortDirection());
        requestOptions.setSortCriteria(ctx.getSortColumn());

        // Retrieve filters
        String[] filters = ctx.getFilters();
        if (filters != null) {
            for (int i = 0; i < filters.length; i++) {
                if (StringHelper.isNotEmpty(filters[i])) {
                    requestOptions.addFilter(new Filter(i, filters[i], getFilterType(ctx.getColumn(
                            i).getFilter())));
                }
            }
        }

        return requestOptions;
    }

    private static FilterType getFilterType(IFilter filter) throws SecurityException,
            NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        FilterType type = null;
        if (filter instanceof ComboFilter) {
            // a combo filter is necessarily a equals filter
            type = FilterType.EQUALS;
        } else if (filter instanceof TextFilter) {
            // a text filter could be equals/like filter

            // Use Java reflexion to access private fields.
            // TODO branch opensuit version to add accessors
            TextFilter tF = (TextFilter) filter;
            Field fd = TextFilter.class.getDeclaredField("function");
            fd.setAccessible(true);
            Object ob = (Object) fd.get(tF);
            if (ob instanceof Equals) {
                type = FilterType.EQUALS;
            } else {
                type = FilterType.LIKE;
            }
        } else {
            type = FilterType.LIKE;
        }
        return type;
    }

}
