/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.gui.beans;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.FlowParamsDetails;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStep;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;

public class FlowDetails {
    private Flow flow;
    private List<FlowStep> steps;
    private FlowRef flowRef;
    private FlowManager flowManager = FlowManager.getInstance();
    private FlowRefManager flowRefManager = FlowRefManager.getInstance();
    private List<FlowParamsDetails> listFlowParamsDetails = new ArrayList();
    FlowStepRef flowStepRef = new FlowStepRef();

    public void load(HttpServletRequest request) {
        String id = request.getParameter("id");
        this.flow = this.flowManager.load(id);
        if (this.flow.getStatus() == null) {
            this.flow.setStatus(Integer.valueOf(-1));
        }
        this.steps = this.flowManager.loadSteps(id);
        this.listFlowParamsDetails = this.flowRefManager.getDetailFlowParameter((short)this.flow.getType(), id);
    }

    public void refresh() {
        this.flow = this.flowManager.load(this.flow.getIdpetals());
        if (this.flow.getStatus() == null) {
            this.flow.setStatus(Integer.valueOf(-1));
        }
        this.steps = this.flowManager.loadSteps(this.flow.getIdpetals());
        this.listFlowParamsDetails = this.flowRefManager.getDetailFlowParameter((short)this.flow.getType(), this.flow.getIdpetals());
    }

    public Flow getFlow() {
        return this.flow;
    }

    public Flow[] getFlows() {
        return new Flow[]{this.flow};
    }

    public List<FlowStep> getSteps() {
        return this.steps;
    }

    public FlowRef getFlowRef() {
        return this.flowRef;
    }

    public String getFlowType() {
        String result = "Undefined flow type";
        if (this.flowRef != null) {
            result = this.flowRef.getName();
        }
        return result;
    }

    public List<FlowParamsDetails> getListFlowParamsDetails() {
        return this.listFlowParamsDetails;
    }

    public String getShortStepName(FlowStep step) {
        String result = "";
        this.flowStepRef = this.flowRefManager.loadStepRef(this.flow.getType(), step.getInterfaceName(), step.getServiceName());
        if (this.flowStepRef != null) {
            result = this.flowStepRef.getName();
            if (result.length() > 30) {
                result = result.substring(0, 27) + "...";
            }
        } else {
            result = step.getInterfaceName() + "/" + step.getServiceName();
            if (result.length() > 30) {
                String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart().length() > 11 ? QName.valueOf(step.getInterfaceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(step.getInterfaceName()).getLocalPart();
                String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 11 ? QName.valueOf(step.getServiceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(step.getServiceName()).getLocalPart();
                result = shortIntName + "/" + shortServName;
            }
        }
        return result;
    }

    public String getStepName(FlowStep step) {
        String result = "";
        result = this.flowStepRef != null ? this.flowStepRef.getName() : step.getInterfaceName() + "/" + step.getServiceName();
        return result;
    }

    public String getStepKey(FlowStep step) {
        return step.getInterfaceName() + "/" + step.getServiceName() + "/" + step.getEndpointName() + "/" + step.getMeUUID();
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }

    public String getStepMessage(FlowStep step) {
        Object result = "No messages defined for this step";
        FlowStepRef flowStepRef = this.flowRefManager.loadStepRef(this.flow.getType(), step.getInterfaceName(), step.getServiceName());
        if (flowStepRef != null) {
            FlowStepErrorRef error;
            result = step.getStatus() == 0 ? flowStepRef.getSuccessMessage() : (step.getStatus() == -1 ? null : ((error = (FlowStepErrorRef)flowStepRef.getErrorMessages().get(step.getStatus())) == null ? (flowStepRef.getDefaultErrorMessage() != null ? flowStepRef.getDefaultErrorMessage() : "Error " + step.getStatus() + " (?)") : error.getMessage()));
        }
        return result;
    }
}

