/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.gui.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;
import org.ow2.petals.flowwatch.flowmanager.bo.StepParameter;
import org.ow2.petals.flowwatch.gui.beans.FlowReferential;

public class FlowReferential {
    private FlowRef flowRef;
    private List<FlowStepRef> stepRefs;
    private long[] selectedSteps;

    public void load(HttpServletRequest request) {
        int type = Integer.parseInt(request.getParameter("type"));
        this.loadFlowRef(type);
        this.loadStepRefs(type);
    }

    private void loadFlowRef(int type) {
        this.flowRef = FlowRefManager.getInstance().getFlowRef(type);
    }

    private void loadStepRefs(int type) {
        this.stepRefs = FlowRefManager.getInstance().loadSteps(type);
        this.selectedSteps = new long[0];
    }

    public void removeStepRefs() {
        FlowRefManager.getInstance().removeStepRefs(this.selectedSteps);
        this.loadStepRefs(this.flowRef.getType());
    }

    public FlowRef getFlowRef() {
        return this.flowRef;
    }

    public List<FlowStepRef> getStepRefs() {
        return this.stepRefs;
    }

    public long[] getSelectedSteps() {
        return this.selectedSteps;
    }

    public void setSelectedSteps(long[] selectedSteps) {
        this.selectedSteps = selectedSteps;
    }

    public String buildErrorMessagesHtml(FlowStepRef step) {
        Map errorMessages = step.getErrorMessages();
        String defaultErrorMessage = step.getDefaultErrorMessage();
        if (!(defaultErrorMessage != null && !"".equals(defaultErrorMessage) || errorMessages != null && errorMessages.size() != 0)) {
            return null;
        }
        Collection errors = errorMessages.values();
        StringBuffer sb = new StringBuffer();
        sb.append("\\html\\");
        sb.append("<ul class=list>\n");
        for (FlowStepErrorRef error : errors) {
            sb.append("<li>");
            sb.append(String.valueOf(error.getErrorCode()));
            sb.append(": ");
            sb.append(error.getMessage());
            sb.append("</li>\n");
        }
        if (defaultErrorMessage != null || !"".equals(defaultErrorMessage)) {
            sb.append("<li>");
            sb.append("default");
            sb.append(": ");
            sb.append(defaultErrorMessage);
            sb.append("</li>\n");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public String getShortStepKey(FlowStepRef step) {
        String result = step.getInterfaceName() + "/" + step.getServiceName();
        if (result.length() > 50) {
            String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart().length() > 21 ? QName.valueOf(step.getInterfaceName()).getLocalPart().substring(0, 20) + "..." : QName.valueOf(step.getInterfaceName()).getLocalPart();
            String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 21 ? QName.valueOf(step.getServiceName()).getLocalPart().substring(0, 20) + "..." : QName.valueOf(step.getServiceName()).getLocalPart();
            result = shortIntName + "/" + shortServName;
        }
        return result;
    }

    public String getStepName(FlowStepRef step) {
        return step.getName();
    }

    public String getShortStepName(FlowStepRef step) {
        String result = "";
        result = step.getName().length() > 50 ? step.getName().substring(0, 46) + "..." : step.getName();
        return result;
    }

    public String getStepKey(FlowStepRef step) {
        return step.getInterfaceName() + "/" + step.getServiceName();
    }

    public List<FlowRefParameter> getFlowParameters() {
        ArrayList<FlowRefParameter> result = new ArrayList<FlowRefParameter>();
        if (this.stepRefs != null) {
            for (FlowStepRef stepRef : this.stepRefs) {
                if (stepRef.getParameterNames() == null) continue;
                for (StepParameter stepParameter : stepRef.getParameterNames()) {
                    if (!stepParameter.isGlobal()) continue;
                    result.add(new FlowRefParameter(this, stepParameter, stepRef));
                }
            }
        }
        return result;
    }
}

