/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.gui.beans;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.table.ITableRenderingContext;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.util.CSVExport;
import org.ow2.petals.flowwatch.util.OpenSuitTableHelper;

public class ListOfFlows {
    private static int[] ALL_STATUS = new int[]{0, 1, 2};
    private List<Flow> flows;
    private Date before;
    private Date after;
    private int rowCount;
    private TableRenderingContext ctx;
    private String fileUrl;
    private String fileName;

    public void loadAll() {
        this.setupFilterToday();
    }

    private void setupFilterToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.after = cal.getTime();
        cal.add(5, 1);
        this.before = cal.getTime();
    }

    public String getShortName(Flow flow) {
        String shortName = flow.getIdpetals();
        if (shortName != null) {
            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {
            shortName = " ";
        }
        return shortName;
    }

    public String getName(Flow flow) {
        String name = flow.getIdpetals();
        return name;
    }

    public void viewAllFlow() {
        this.after = null;
        this.before = null;
    }

    public void validateFilter() throws ValidationErrors {
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();
        if (this.after != null && this.after.after(now)) {
            errors.addItemError("flows.after", (ValidationError)new LocalizedValidationError("validation.date.future"));
        }
        if (this.before != null && this.after != null && this.after.after(this.before)) {
            errors.addItemError("flows.before", (ValidationError)new LocalizedValidationError("validation.date.negative_range"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void refresh() {
        if (this.after == null && this.before == null) {
            this.viewAllFlow();
        } else {
            this.setupFilterToday();
        }
    }

    public void exportFlows(HttpServletRequest request, HttpServletResponse response, String nbOfResultStg) throws Exception {
        CSVExport csv = new CSVExport();
        int nbOfResult = 0;
        try {
            nbOfResult = Integer.valueOf(nbOfResultStg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        csv.exportFlows(request, response, this.ctx, this.after, this.before, this.rowCount, nbOfResult);
    }

    public List<Flow> getFlows() throws Exception {
        this.ctx = (TableRenderingContext)ITableRenderingContext.get((HttpServletRequest)OpenSuitSession.getCurrentRequest());
        if (this.ctx != null) {
            RequestOptions requestOptions = OpenSuitTableHelper.createRequestOption((TableRenderingContext)this.ctx);
            this.rowCount = FlowManager.getInstance().countAllFlows(this.after, this.before, requestOptions);
            this.ctx.setRowsCount(this.rowCount);
            if (this.rowCount != 0) {
                this.flows = FlowManager.getInstance().getAllFlows(this.after, this.before, requestOptions);
                return this.flows;
            }
            return null;
        }
        return null;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    public Date getBefore() {
        return this.before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return this.after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }
}

