/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.gui.beans;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.table.ITableRenderingContext;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.util.CSVExport;
import org.ow2.petals.flowwatch.util.OpenSuitTableHelper;

public class ListOfFlowsByType {
    private static int[] ALL_STATUS = new int[]{0, 1, 2};
    private int type = -1;
    private int[] paramIndex;
    private Date before;
    private Date after;
    private List<GlobalFlowParam> listGlobalFlowParam;
    private List<FlowWithParams> listFlowWithParams;
    private int rowCount;
    private TableRenderingContext ctx;

    public void loadByType(HttpServletRequest request) {
        this.type = Integer.parseInt(request.getParameter("type"));
        this.setupFilterToday();
        this.listGlobalFlowParam = FlowRefManager.getInstance().getGlobalFlowParameters((short)this.type);
        this.paramIndex = new int[this.listGlobalFlowParam.size()];
        for (int i = 0; i < this.paramIndex.length; ++i) {
            this.paramIndex[i] = i;
        }
    }

    private void setupFilterToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.after = cal.getTime();
        cal.add(5, 1);
        this.before = cal.getTime();
    }

    public String getFlowParameterName(int numIndex) {
        String name = ((GlobalFlowParam)this.listGlobalFlowParam.get(numIndex)).getName();
        return name;
    }

    public String getShortName(FlowWithParams flowWithParams) {
        String shortName = flowWithParams.getIdpetals();
        if (shortName != null) {
            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {
            shortName = " ";
        }
        return shortName;
    }

    public String getName(FlowWithParams flowWithParams) {
        String name = flowWithParams.getIdpetals();
        return name;
    }

    public void viewAllFlow() {
        this.after = null;
        this.before = null;
    }

    public void validateFilter() throws ValidationErrors {
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();
        if (this.after != null && this.after.after(now)) {
            errors.addItemError("flows.after", (ValidationError)new LocalizedValidationError("validation.date.future"));
        }
        if (this.before != null && this.after != null && this.after.after(this.before)) {
            errors.addItemError("flows.before", (ValidationError)new LocalizedValidationError("validation.date.negative_range"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void applyFilterByType() {
    }

    public void refresh() {
        if (this.after == null && this.before == null) {
            this.viewAllFlow();
        } else {
            this.setupFilterToday();
        }
    }

    public void exportFlows(HttpServletRequest request, HttpServletResponse response, String nbOfResultStg) throws Exception {
        CSVExport csv = new CSVExport();
        int nbOfResult = 0;
        try {
            nbOfResult = Integer.valueOf(nbOfResultStg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        csv.exportFlowsByType(request, response, this.ctx, this.after, this.before, this.listGlobalFlowParam, (short)this.type, this.rowCount, nbOfResult);
    }

    public int[] getParamIndex() {
        return this.paramIndex;
    }

    public List<FlowWithParams> getFlowsWithParams() throws Exception {
        this.ctx = (TableRenderingContext)ITableRenderingContext.get((HttpServletRequest)OpenSuitSession.getCurrentRequest());
        if (this.ctx != null) {
            RequestOptions requestOptions = OpenSuitTableHelper.createRequestOption((TableRenderingContext)this.ctx);
            this.rowCount = FlowManager.getInstance().countAllFlowsByType(this.after, this.before, this.listGlobalFlowParam, (short)this.type, requestOptions);
            this.ctx.setRowsCount(this.rowCount);
            if (this.rowCount != 0) {
                this.listFlowWithParams = FlowManager.getInstance().getAllFlowsByType(this.after, this.before, this.listGlobalFlowParam, (short)this.type, requestOptions);
                return this.listFlowWithParams;
            }
            return null;
        }
        return null;
    }

    public Date getBefore() {
        return this.before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return this.after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }
}

