/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.gui.beans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.BeanUtils;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;

public class ReferentialBean {
    private List<FlowRef> flowRefs;
    private Map<Integer, FlowRef> typeToRef;

    public static void reload() throws Exception {
        ((ReferentialBean)BeanUtils.getOpenSuitBean((HttpServletRequest)OpenSuitSession.getCurrentRequest(), (String)"referential")).load();
    }

    public ReferentialBean() {
        this.load();
    }

    private void load() {
        this.flowRefs = FlowRefManager.getInstance().loadAll();
        this.typeToRef = new HashMap();
        for (FlowRef fr : this.flowRefs) {
            this.typeToRef.put(fr.getType(), fr);
        }
    }

    public List<FlowRef> getAllFlows() {
        return this.flowRefs;
    }

    public FlowRef getFlowRef(int type) {
        return (FlowRef)this.typeToRef.get(type);
    }

    public String getFlowRefName(int type) {
        String result = "Unknown";
        FlowRef flowRef = (FlowRef)this.typeToRef.get(type);
        if (flowRef != null) {
            result = flowRef.getName();
        }
        return result;
    }

    public String getFlowRefName(HttpServletRequest request) {
        String result = "Unknown";
        int type = Integer.parseInt(request.getParameter("type"));
        FlowRef flowRef = (FlowRef)this.typeToRef.get(type);
        if (flowRef != null) {
            result = flowRef.getName();
        }
        return result;
    }
}

