/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.gui.beans;

import javax.servlet.http.HttpServletRequest;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;

public class StepErrorRefDetails {
    private int errorCode;
    private String errorMessage;
    private FlowStepErrorRef stepErrorRef;
    private long stepRefId;

    public FlowStepErrorRef getStepErrorRef() {
        return this.stepErrorRef;
    }

    public void setStepErrorRef(FlowStepErrorRef stepErrorRef) {
        this.stepErrorRef = stepErrorRef;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void load(HttpServletRequest request) {
        long id = Long.parseLong(request.getParameter("id"));
        this.init(request);
        this.loadStepErrorRef(id);
    }

    public void init(HttpServletRequest request) {
        this.stepRefId = Long.parseLong(request.getParameter("stepRefId"));
    }

    private void loadStepErrorRef(long id) {
        this.stepErrorRef = FlowRefManager.getInstance().loadStepErrorRef(id);
        this.reset();
    }

    public void reset() {
        this.errorCode = this.stepErrorRef.getErrorCode();
        this.errorMessage = this.stepErrorRef.getMessage();
    }

    public String create() throws LocalizedError {
        FlowStepErrorRef stepErrorRef = new FlowStepErrorRef();
        stepErrorRef.setErrorCode(this.errorCode);
        stepErrorRef.setMessage(this.errorMessage);
        stepErrorRef.setFlowStepRef(FlowRefManager.getInstance().loadStepRef(this.stepRefId));
        try {
            FlowRefManager.getInstance().saveOrUpdateErrorRef(stepErrorRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowsteperrorref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        return "success";
    }

    public String update() throws LocalizedError {
        this.stepErrorRef.setErrorCode(this.errorCode);
        this.stepErrorRef.setMessage(this.errorMessage);
        try {
            FlowRefManager.getInstance().saveOrUpdateErrorRef(this.stepErrorRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowsteperrorref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        return "success";
    }
}

