/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.gui.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManager;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManagerRuntimeException;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;

public class StepRefDetails {
    private String interfaceName;
    private String serviceName;
    private String functionalName;
    private boolean startStep = false;
    private boolean endStep = false;
    private String successMessage;
    private String defaultErrorMessage;
    private int flowRefType;
    private FlowStepRef flowStepRef;
    private long[] selectedErrorIds;
    private int[] selectedParamIndexes;
    private int[] paramIndex;

    public void load(HttpServletRequest request) {
        long id = Long.parseLong(request.getParameter("id"));
        this.flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
        this.loadStepRef(id);
        this.paramIndex = new int[this.flowStepRef.getParameterNames().size()];
        for (int i = 0; i < this.paramIndex.length; ++i) {
            this.paramIndex[i] = i;
        }
    }

    private void loadFlowParams(long id) {
        this.flowStepRef = FlowRefManager.getInstance().loadStepRef(id);
        this.selectedParamIndexes = new int[0];
    }

    public void init(HttpServletRequest request) {
        this.flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
    }

    private void loadStepRef(long id) {
        this.flowStepRef = FlowRefManager.getInstance().loadStepRef(id);
        this.reset();
    }

    public void reset() {
        this.interfaceName = this.flowStepRef.getInterfaceName();
        this.serviceName = this.flowStepRef.getServiceName();
        this.functionalName = this.flowStepRef.getName();
        this.startStep = this.flowStepRef.isFlowStartStep();
        this.endStep = this.flowStepRef.isFlowEndStep();
        this.successMessage = this.flowStepRef.getSuccessMessage();
        this.defaultErrorMessage = this.flowStepRef.getDefaultErrorMessage();
        this.selectedErrorIds = new long[0];
    }

    public String create() throws LocalizedError {
        FlowStepRef flowStepRef = new FlowStepRef();
        flowStepRef.setFlowEndStep(this.endStep);
        flowStepRef.setFlowref(FlowRefManager.getInstance().getFlowRef(this.flowRefType));
        flowStepRef.setFlowStartStep(this.startStep);
        flowStepRef.setInterfaceName(this.interfaceName);
        flowStepRef.setName(this.functionalName);
        flowStepRef.setServiceName(this.serviceName);
        flowStepRef.setSuccessMessage(this.successMessage);
        flowStepRef.setDefaultErrorMessage(this.defaultErrorMessage);
        try {
            FlowRefManager.getInstance().saveOrUpdateStepRef(flowStepRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        return "success";
    }

    public String update() throws LocalizedError {
        this.flowStepRef.setFlowEndStep(this.endStep);
        this.flowStepRef.setFlowStartStep(this.startStep);
        this.flowStepRef.setInterfaceName(this.interfaceName);
        this.flowStepRef.setName(this.functionalName);
        this.flowStepRef.setServiceName(this.serviceName);
        this.flowStepRef.setSuccessMessage(this.successMessage);
        this.flowStepRef.setDefaultErrorMessage(this.defaultErrorMessage);
        try {
            FlowRefManager.getInstance().saveOrUpdateStepRef(this.flowStepRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        return "success";
    }

    public String removeErrorRefs() {
        FlowRefManager.getInstance().removeErrorRefs(this.selectedErrorIds);
        this.loadStepRef(this.flowStepRef.getId());
        return "success";
    }

    public int[] makeIndexes(int size) {
        int[] ret = new int[size];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public String addParameterName(int index, String name, boolean global) {
        FlowRefManager.getInstance().addParameterName(this.flowStepRef.getId(), index, name, global);
        this.loadFlowParams(this.flowStepRef.getId());
        return "success";
    }

    public String updateParameterName(int index, String name, boolean global) {
        FlowRefManager.getInstance().updateParameterName(this.flowStepRef.getId(), index, name, global);
        this.loadFlowParams(this.flowStepRef.getId());
        return "success";
    }

    public String removeParameterNames() {
        FlowRefManager.getInstance().removeParameterNames(this.flowStepRef.getId(), this.selectedParamIndexes);
        this.loadFlowParams(this.flowStepRef.getId());
        return "success";
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public int[] getParamIndex() {
        return this.paramIndex;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getFunctionalName() {
        return this.functionalName;
    }

    public void setFunctionalName(String functionalName) {
        this.functionalName = functionalName;
    }

    public boolean isStartStep() {
        return this.startStep;
    }

    public void setStartStep(boolean startStep) {
        this.startStep = startStep;
    }

    public boolean isEndStep() {
        return this.endStep;
    }

    public void setEndStep(boolean endStep) {
        this.endStep = endStep;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public FlowStepRef getFlowStepRef() {
        return this.flowStepRef;
    }

    public void setFlowStepRef(FlowStepRef flowStepRef) {
        this.flowStepRef = flowStepRef;
    }

    public int getFlowRefType() {
        return this.flowRefType;
    }

    public void setFlowRefType(int flowRefType) {
        this.flowRefType = flowRefType;
    }

    public long[] getSelectedErrorIds() {
        return this.selectedErrorIds;
    }

    public void setSelectedErrorIds(long[] selectedErrorIds) {
        this.selectedErrorIds = selectedErrorIds;
    }

    public Collection<FlowStepErrorRef> getErrorMessages() {
        ArrayList flowErrorStepRefs = null;
        if (this.flowStepRef.getErrorMessages() != null && this.flowStepRef.getErrorMessages().size() != 0) {
            flowErrorStepRefs = new ArrayList();
            flowErrorStepRefs.addAll(this.flowStepRef.getErrorMessages().values());
            Collections.sort(flowErrorStepRefs);
        }
        return flowErrorStepRefs;
    }

    public String getDefaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public int[] getSelectedParamIndexes() {
        return this.selectedParamIndexes;
    }

    public void setSelectedParamIndexes(int[] selectedParamIndexes) {
        this.selectedParamIndexes = selectedParamIndexes;
    }
}

