/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.petals.flowwatch.flowmanager.FlowManager;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.util.OpenSuitTableHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class CSVExport {
    private String separator = ";";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFlowsByType(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, Date after, Date before, List<GlobalFlowParam> listGlobalFlowParam, short type, int rowCount, int nbOfResult) throws Exception {
        this.setResponseInfo(iRequest, iResponse);
        PrintWriter printer = iResponse.getWriter();
        this.createColumnHeaderTitle(iRequest, context, printer);
        RequestOptions requestOptions = this.createRequestOptions(context, nbOfResult);
        int firstIndex = 0;
        try {
            while (rowCount > 0) {
                requestOptions.setFirstResult(firstIndex);
                List flows = FlowManager.getInstance().getAllFlowsByType(after, before, listGlobalFlowParam, type, requestOptions);
                this.createColumnValues(iRequest, context, printer, flows);
                firstIndex += requestOptions.getNbOfResults();
                rowCount -= requestOptions.getNbOfResults();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (printer != null) {
                printer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFlows(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, Date after, Date before, int rowCount, int nbOfResult) throws Exception {
        this.setResponseInfo(iRequest, iResponse);
        PrintWriter printer = iResponse.getWriter();
        this.createColumnHeaderTitle(iRequest, context, printer);
        RequestOptions requestOptions = this.createRequestOptions(context, nbOfResult);
        int firstIndex = 0;
        try {
            while (rowCount > 0) {
                requestOptions.setFirstResult(firstIndex);
                List flows = FlowManager.getInstance().getAllFlows(after, before, requestOptions);
                this.createColumnValues(iRequest, context, printer, flows);
                firstIndex += requestOptions.getNbOfResults();
                rowCount -= requestOptions.getNbOfResults();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (printer != null) {
                printer.close();
            }
        }
    }

    private RequestOptions createRequestOptions(TableRenderingContext context, int nbOfResult) throws Exception {
        RequestOptions requestOptions = OpenSuitTableHelper.createRequestOption((TableRenderingContext)context);
        requestOptions.setNbOfResults(nbOfResult);
        return requestOptions;
    }

    private void createColumnValues(HttpServletRequest iRequest, TableRenderingContext context, PrintWriter printer, List<?> flows) throws Exception, IOException {
        if (flows != null && !flows.isEmpty()) {
            for (Object rowObj : flows) {
                iRequest.setAttribute(context.getTable().getRowBeanName(), rowObj);
                int iDisplayedCol = 0;
                for (TableRenderingContext.ColumnDef col : context.getColumns()) {
                    if (!col.isVisible()) continue;
                    if (iDisplayedCol > 0) {
                        printer.print(this.separator);
                    }
                    Object cellData = col.getProvider().getCellDisplayedContent(iRequest, col, rowObj);
                    String cellTest = String.valueOf(cellData);
                    String[] params = cellTest.split("<");
                    String[] myCurrParam = null;
                    for (int i = 0; i < params.length; ++i) {
                        myCurrParam = params[i].split(">");
                        for (int j = 0; j < myCurrParam.length; ++j) {
                            if (j != 1 || i != 1) continue;
                            cellData = myCurrParam[1];
                        }
                    }
                    CSVExport.write2CSV((PrintWriter)printer, (Object)cellData);
                    ++iDisplayedCol;
                }
                printer.print('\n');
            }
            printer.flush();
        }
    }

    private void createColumnHeaderTitle(HttpServletRequest iRequest, TableRenderingContext context, PrintWriter printer) throws IOException, Exception {
        int iDisplayedCol = 0;
        for (TableRenderingContext.ColumnDef col : context.getColumns()) {
            if (!col.isVisible()) continue;
            if (iDisplayedCol > 0) {
                printer.print(this.separator);
            }
            CSVExport.write2CSV((PrintWriter)printer, (Object)col.getProvider().getColumnTitle(iRequest, col));
            ++iDisplayedCol;
        }
        printer.print('\n');
    }

    private void setResponseInfo(HttpServletRequest iRequest, HttpServletResponse iResponse) {
        OpenSuitSession session = OpenSuitSession.getSession((HttpServletRequest)iRequest);
        iResponse.setContentType("text/petlasviewexport;charset=" + session.getLocaleConfig().getCharSet());
        iResponse.setHeader("Cache-Control", "no-cache");
        iResponse.setHeader("Pragma", "no-cache");
        iResponse.setDateHeader("Expires", 0L);
    }

    private static void write2CSV(PrintWriter writer, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value.getClass() == Boolean.class || value.getClass() == Boolean.TYPE) {
            writer.print(String.valueOf(value));
        } else if (Number.class.isInstance(value)) {
            writer.print(String.valueOf(value));
        } else if (value.getClass().isPrimitive()) {
            writer.print(String.valueOf(value));
        } else if (Date.class.isInstance(value) || Calendar.class.isInstance(value)) {
            writer.print(String.valueOf(value));
        } else {
            String text = String.valueOf(value);
            int nbChars = text.length();
            writer.write(34);
            block3: for (int i = 0; i < nbChars; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '\"': {
                        writer.print("\"\"");
                        continue block3;
                    }
                    default: {
                        writer.write(c);
                    }
                }
            }
            writer.write(34);
        }
    }
}

