/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.plugin.jbiplugin.JBIPackageMojo;
import org.ow2.petals.plugin.jbiplugin.mock.ArtifactMock;
import org.ow2.petals.plugin.jbiplugin.mock.ArtifactRepositoryMock;

public class JBIPluginMojoTest {
    @Test
    public void testExecute() throws MojoExecutionException {
        String baseDir = this.getClass().getResource(".").toString();
        baseDir = baseDir.substring(0, baseDir.indexOf("target"));
        baseDir = baseDir.substring(baseDir.indexOf(":") + 1);
        baseDir = baseDir.replaceAll("%20", " ");
        JBIPackageMojo plugin = new JBIPackageMojo();
        plugin.jbiDirectory = new File(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "jbi");
        ArtifactRepositoryMock artifactRepositoryMock = new ArtifactRepositoryMock();
        artifactRepositoryMock.setBaseDir(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "repository");
        plugin.localRepository = artifactRepositoryMock;
        MavenProject project = new MavenProject();
        project.setArtifact((Artifact)new ArtifactMock());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Dependency dependency = new Dependency();
        dependency.setArtifactId("test");
        dependency.setGroupId("test");
        dependency.setVersion("1.0");
        dependencies.add(dependency);
        project.setDependencies(dependencies);
        plugin.toExcludes = "";
        plugin.project = project;
        plugin.outputDirectory = new File(baseDir + "target");
        plugin.jbiName = "test";
        plugin.artifactJar = new File(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "component.jar");
        try {
            plugin.execute();
        }
        catch (MojoFailureException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteWithSubDep() throws MojoExecutionException {
        String baseDir = new File(".").getAbsolutePath();
        baseDir = baseDir.substring(0, baseDir.length() - 1);
        JBIPackageMojo plugin = new JBIPackageMojo();
        plugin.jbiDirectory = new File(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "jbi");
        ArtifactRepositoryMock artifactRepositoryMock = new ArtifactRepositoryMock();
        artifactRepositoryMock.setBaseDir(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "repository");
        plugin.localRepository = artifactRepositoryMock;
        MavenProject project = new MavenProject();
        project.setArtifact((Artifact)new ArtifactMock());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Dependency dependency = new Dependency();
        dependency.setArtifactId("test");
        dependency.setGroupId("test");
        dependency.setVersion("1.0");
        dependencies.add(dependency);
        project.setDependencies(dependencies);
        plugin.project = project;
        plugin.toExcludes = "";
        plugin.outputDirectory = new File(baseDir + "target");
        plugin.jbiName = "test";
        plugin.artifactJar = new File(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "component.jar");
        try {
            plugin.execute();
        }
        catch (MojoFailureException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteUpdateJBI() throws MojoExecutionException {
        String baseDir = new File(".").getAbsolutePath();
        baseDir = baseDir.substring(0, baseDir.length() - 1);
        JBIPackageMojo plugin = new JBIPackageMojo();
        plugin.jbiDirectory = new File(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "jbi");
        ArtifactRepositoryMock artifactRepositoryMock = new ArtifactRepositoryMock();
        artifactRepositoryMock.setBaseDir(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "repository");
        plugin.localRepository = artifactRepositoryMock;
        MavenProject project = new MavenProject();
        project.setArtifact((Artifact)new ArtifactMock());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Dependency dependency = new Dependency();
        dependency.setArtifactId("test");
        dependency.setGroupId("test");
        dependency.setVersion("1.0");
        dependencies.add(dependency);
        project.setDependencies(dependencies);
        plugin.project = project;
        plugin.toExcludes = "";
        plugin.updateJBIXml = true;
        plugin.outputDirectory = new File(baseDir + "target");
        plugin.jbiName = "test";
        plugin.artifactJar = new File(baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "component.jar");
        try {
            plugin.execute();
        }
        catch (MojoFailureException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

