/**
 * 
 */

package org.ow2.petals.flowwatch.flowmanager;

import org.ow2.petals.flowwatch.flowmanager.Filter.FilterType;

/**
 * @author ofabre
 * 
 */
public abstract class AbstractCreateSQLQuery {

    protected abstract String getSelectByAttribute();

    /**
     * A "select" clause to count all rows of a specific request
     * 
     * @return
     */
    protected String getSelectForCount() {
        return "select COUNT(*) ";
    }

    /**
     * Add the "from" clause
     * 
     * @return
     */
    protected String getFrom() {
        return " from FLOW f ";
    }

    /**
     * Add the flow ref join clause. It joins on the provided flow type
     * 
     * @param type
     *            a given flow type
     * @return
     */
    protected String getFlowRefLeftJoinByType(String type) {
        return getFlowRefLeftJoin(type);
    }

    /**
     * Add the flow ref join clause. It joins on each flow type. Used in global
     * query where there're a lots of different flow types
     * 
     * @return
     */
    protected String getFlowRefLeftJoinGlobal() {
        return getFlowRefLeftJoin("f.type");
    }

    private String getFlowRefLeftJoin(String flowTypePart) {
        final StringBuffer queryBuf = new StringBuffer();
        queryBuf.append(" left join FLOWREF fr ");
        queryBuf.append(" on fr.type = " + flowTypePart + " ");
        return queryBuf.toString();
    }

    /**
     * Add the flow step ref and corresponding flow step left join clause. For
     * the flow end step
     * 
     * @return
     */
    protected String getLastStepLeftJoin() {
        final StringBuffer queryBuf = new StringBuffer();

        queryBuf.append("left join FLOWSTEPREF lfsr ");
        queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = true ");
        queryBuf.append("left join FLOWSTEP lfs ");
        queryBuf.append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName and lfs.interfaceName = lfsr.interfaceName ");

        return queryBuf.toString();
    }

    /**
     * Add the flow step ref and corresponding flow step left join clause. For
     * the flow start step
     * 
     * @return
     */
    protected String getStartStepLeftJoin() {
        final StringBuffer queryBuf = new StringBuffer();

        queryBuf.append(" left join FLOWSTEPREF ffsr ");
        queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = true ");
        queryBuf.append("left join FLOWSTEP ffs ");
        queryBuf.append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName and ffs.interfaceName = ffsr.interfaceName ");

        return queryBuf.toString();
    }


    /**
     * A generic order by method used to order flow when no sort option selected
     * 
     * @return
     */
    protected String getGlobalOrderBy() {
        return " order by ffs.startdate, lfs.status, f.id ";
    }

    protected abstract String sort(int idxColumn, String sortType);

    /**
     * Add "order by" clause. Sort descendingly on the given column index
     * 
     * @param idxColumn
     *            the index of the column to sort
     * @return
     */
    protected String sortDesc(int idxColumn) {
        return sort(idxColumn, "Desc");
    }

    /**
     * Add "order by" clause. Sort ascendingly on the given column index
     * 
     * @param idxColumn
     *            the index of the column to sort
     * @return
     */
    protected String sortAsc(int idxColumn) {
        return sort(idxColumn, "Asc");
    }

    /**
     * Add the "limit" clause. Start from the "indxFirst" and ends on the
     * "indxFirst + rowsPerPage"
     * 
     * @param indxFirst
     *            start index of the returned result
     * @param rowsPerPage
     *            number of returned results
     * @return
     */
    protected String getLimit(int indxFirst, int rowsPerPage) {
        return " limit " + indxFirst + ", " + rowsPerPage;
    }

    /**
     * Return the mysql operator for a given filter type
     * 
     * @param type
     *            a filter type
     * @return
     */
    protected String getMySQLFilterType(FilterType type, String value) {
        switch (type) {
            case LIKE:
                return "like '%"+value+"%'";
            case EQUALS:
                return "= '"+value+"'";
            default:
                return "= '"+value+"'";
        }
    }

}
