
package org.ow2.petals.flowwatch.flowmanager;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class CreateSqlQueryFlow extends AbstractCreateSQLQuery {

    public CreateSqlQueryFlow() {
        super();
    }

    protected String getSelectByAttribute() {
        return "select f.id,f.idpetals, ffs.startDate, lfs.endDate, f.type, lfs.status ";
    }

    protected String sort(int idxColumn, String sortType) {
        String sort = null;

        switch (idxColumn) {
            case 0: // Type
                sort = " order by f.type " + sortType + " ";
                break;
            case 1: // ID
                sort = " order by f.id " + sortType + " ";
                break;
            case 2: // Start Date
                sort = " order by  ffs.startdate " + sortType + " ";
                break;
            case 3: // End Date
                sort = " order by  lfs.endDate " + sortType + " ";
                break;
            case 4: // Status
                sort = " order by lfs.status " + sortType + " ";
                break;
        }
        return sort;
    }
    
    /**
     * Add a where clause for the start date
     * 
     * @param after
     * @param before
     * @return
     */
    protected String getWhereDateClause(final Date after, final Date before) {
        final StringBuffer queryBuf = new StringBuffer();

        if (before != null || after != null) {
            queryBuf.append("where ffs.startdate is not null ");
        }

        if (before != null) {
            final Timestamp beforeTsp = new Timestamp(before.getTime());
            queryBuf.append(" and ffs.startdate < '" + beforeTsp + "'");
        }
        if (after != null) {
            final Timestamp afterTsp = new Timestamp(after.getTime());
            queryBuf.append(" and ffs.startdate > '" + afterTsp + "' ");
        }

        return queryBuf.toString();
    }

    /**
     * Add a where clause for flow type and status filters
     * 
     * @param allFilters
     *            the list of all filters to apply (handle generic filters only)
     * @param after
     *            the date before
     * @param before
     *            the date after
     * @return
     */
    private String getWhereFilterClose(List<Filter> allFilters, final Date after,
            final Date before) {
        String filter1 = "";
        String filter3 = "";
        String where = "";

        // Add a where clause if no where clause added for date
        if (before == null && after == null) {
            where = " where ";
        } else {
            where = " and ";
        }
        for (int i = 0; i < allFilters.size(); i++) {
            // filter on flow type
            if (allFilters.get(i).getIndexColumn() == 0) {
                String value = allFilters.get(i).getValue();
                filter1 = " f.type = " + value + " and ";
            }

            // filter on status
            if (allFilters.get(i).getIndexColumn() == 4) {
                String value = allFilters.get(i).getValue();

                if (value.equals("2")) {
                    filter3 = " ( lfs.endDate is null or lfs.status = -1 ) ";
                } else if (value.equals("1")) {
                    value = " >0";
                    filter3 = " lfs.status " + value;
                } else {
                    value = " = 0";
                    filter3 = " lfs.status " + value;
                }

                filter3 = filter3 + " and ";
            }

        }
        String result = where + filter1 + filter3;
        
        return result.substring(0, result.length()-5);
    }

    public String createGetQuery(Date after, Date before, RequestOptions reqOpt) {
        // Create select from part
        String sql = getSelectByAttribute() + getFrom();

        // Append join
        sql = sql + getFlowRefLeftJoinGlobal() + getStartStepLeftJoin() + getLastStepLeftJoin();

        // Append where on date
        sql = sql + getWhereDateClause(after, before);

        // Append filter
        if (reqOpt.hasFilterOption()) {
            sql = sql + getWhereFilterClose(reqOpt.getFilters(), after, before);
        }

        // Append sort
        if (reqOpt.hasSortOption()) {
            if (reqOpt.isSortAscendingly()) {
                sql = sql + sortAsc(reqOpt.getSortCriteria());
            } else {
                sql = sql + sortDesc(reqOpt.getSortCriteria());
            }
        } else {
            sql = sql + getGlobalOrderBy();
        }

        // Append pagination
        if (reqOpt.hasPagination()) {
            sql = sql + getLimit(reqOpt.getFirstResult(), reqOpt.getNbOfResults());
        }

        return sql;
    }

    public String createCountQuery(Date after, Date before, RequestOptions reqOpt) {
        // Create select from part
        String sql = getSelectForCount() + getFrom();

        // Append join and where clause
        if (after != null || before != null) {
            if (reqOpt.hasFilterOption()) {
                // Append join
                sql = sql + getFlowRefLeftJoinGlobal() + getStartStepLeftJoin()
                        + getLastStepLeftJoin();
                // Append join and where clause
                sql = sql + getWhereDateClause(after, before);
                // Append filter
                sql = sql + getWhereFilterClose(reqOpt.getFilters(), after, before);
            } else {
                sql = sql + getFlowRefLeftJoinGlobal() + getStartStepLeftJoin();
                sql = sql + getWhereDateClause(after, before);
            }
        } else {
            if (reqOpt.hasFilterOption()) {
                // Append join
                sql = sql + getFlowRefLeftJoinGlobal() + getLastStepLeftJoin();
                // Append filter
                sql = sql + getWhereFilterClose(reqOpt.getFilters(), after, before);
            }
        }

        return sql;
    }

}
