
package org.ow2.petals.flowwatch.flowmanager;

import java.util.Date;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;
import org.ow2.petals.flowwatch.flowmanager.bo.StepParameter;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowRefDAO;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowStepErrorRefDAO;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowStepRefDAO;

public class FlowRefManager extends ConfigAndFactoryManager {

    private static FlowRefManager instance;

    private static FlowRefDAO flowRefDAO = FlowRefDAO.getInstance();

    private static FlowStepRefDAO flowStepRefDAO = FlowStepRefDAO.getInstance();

    private static FlowStepErrorRefDAO flowStepErrorsRefDAO = FlowStepErrorRefDAO.getInstance();

    public FlowRefManager() {
        super();
    }

    static {
        instance = new FlowRefManager();
    }

    public static FlowRefManager getInstance() {
        return instance;
    }

    public FlowRef getFlowRef(final int type) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowRef result = flowRefDAO.loadByType(type);
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowStepRef> loadSteps(final int type) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final List<FlowStepRef> result = flowStepRefDAO.loadByFlowType(type);
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStepRef loadStepRef(final int type, final String interfaceName,
            final String serviceName) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowStepRef result = flowStepRefDAO.loadByFlowTypeIntNameServName(type,
                    interfaceName, serviceName);
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStepRef loadStepRef(final long id) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowStepRef result = flowStepRefDAO.find(id);
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStepErrorRef loadStepErrorRef(final long id) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowStepErrorRef result = flowStepErrorsRefDAO.find(id);
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowStepErrorRef> loadStepRefErrors(final long stepRefId) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final List<FlowStepErrorRef> result = flowStepErrorsRefDAO.loadByStepRefId(stepRefId);
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowRef> loadAll() {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final List<FlowRef> result = flowRefDAO.findAll();
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public long createFlowRef(final int type, final String name) {
        final FlowRef flowRef = new FlowRef();
        flowRef.setName(name);
        flowRef.setType(type);
        flowRef.setCreationDate(new Date());

        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            flowRefDAO.save(flowRef);
            final long id = flowRef.getId();
            tx.commit();
            return id;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeFlowRef(final int[] flowRefTypes) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            for (final int type : flowRefTypes) {
                final List<FlowStepRef> steps = flowStepRefDAO.loadByFlowType(type);
                if (steps != null) {
                    for (final FlowStepRef step : steps) {
                        flowStepRefDAO.remove(step);
                    }
                }
                flowRefDAO.remove(flowRefDAO.loadByType(type));
            }
            tx.commit();
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeParameterName(final long flowStepId, final int index) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowStepRef result = flowStepRefDAO.find(flowStepId);
            result.removeParameterName(index);
            flowStepRefDAO.save(result);
            tx.commit();
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeParameterNames(final long flowStepId, final int[] indexes) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowStepRef result = flowStepRefDAO.find(flowStepId);
            this.removeParameterName(result, indexes);
            flowStepRefDAO.save(result);
            tx.commit();
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeErrorRefs(final long[] ids) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            for (final long id : ids) {
                flowStepErrorsRefDAO.remove(flowStepErrorsRefDAO.find(id));
            }
            tx.commit();
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    private void removeParameterName(final FlowStepRef flowStepRef, final int[] indexes) {
        if (indexes.length > 0) {
            flowStepRef.removeParameterName(indexes[0]);

            final int[] decrementedIndexes = new int[indexes.length - 1];
            for (int i = 1; i < indexes.length; i++) {
                final int treatedInt = indexes[i];
                if (treatedInt > indexes[0]) {
                    decrementedIndexes[i - 1] = treatedInt - 1;
                } else {
                    decrementedIndexes[i - 1] = treatedInt;
                }
            }
            this.removeParameterName(flowStepRef, decrementedIndexes);
        }
    }

    public void addParameterName(final long flowRefId, final String parameterName,
            final boolean global) {
        this.addParameterName(flowRefId, -1, parameterName, global);
    }

    public void addParameterName(final long flowStepRefId, final int index,
            final String parameterName, final boolean global) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowStepRef flowstepRef = flowStepRefDAO.find(flowStepRefId);
            if (index > -1) {
                final StepParameter parameter = new StepParameter(parameterName, global);
                flowstepRef.addParameterName(index, parameter);
            } else {
                final StepParameter parameter = new StepParameter(parameterName, global);
                flowstepRef.addParameterName(parameter);
            }
            flowStepRefDAO.save(flowstepRef);
            tx.commit();
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void updateParameterName(final long flowStepRefId, final int index,
            final String parameterName, final boolean global) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            final FlowStepRef flowStepRef = flowStepRefDAO.find(flowStepRefId);
            final StepParameter parameter = new StepParameter(parameterName, global);
            flowStepRef.updateParameterName(index, parameter);
            flowStepRefDAO.save(flowStepRef);
            tx.commit();
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeStepRefs(final long[] ids) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            for (final long id : ids) {
                flowStepRefDAO.remove(flowStepRefDAO.find(id));
            }
            tx.commit();
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public long saveOrUpdateStepRef(final FlowStepRef flowStepRef) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            // Avoid multiple start steps
            if (flowStepRef.isFlowStartStep()) {
                final FlowStepRef existingStartStep = flowStepRefDAO
                        .loadStartStepByFlowType(flowStepRef.getFlowref().getType());
                if (existingStartStep != null) {
                    if (existingStartStep.getId() != flowStepRef.getId()) {
                        throw new FlowRefManagerRuntimeException(
                                "Already existing start flow step for this type of flow");
                    } else {
                        session.evict(existingStartStep);
                    }
                }
            }

            // Avoid multiple end steps
            if (flowStepRef.isFlowEndStep()) {
                final FlowStepRef existingEndStep = flowStepRefDAO
                        .loadEndStepByFlowType(flowStepRef.getFlowref().getType());
                if (existingEndStep != null) {
                    if (existingEndStep.getId() != flowStepRef.getId()) {
                        throw new FlowRefManagerRuntimeException(
                                "Already existing end flow step for this type of flow");
                    } else {
                        session.evict(existingEndStep);
                    }
                }
            }
            flowStepRefDAO.save(flowStepRef);
            final long result = flowStepRef.getId();
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public long saveOrUpdateErrorRef(final FlowStepErrorRef stepErrorRef) {
        final Session session = this.configAndFactory.getFactory().getCurrentSession();
        final Transaction tx = session.beginTransaction();
        try {
            flowStepErrorsRefDAO.save(stepErrorRef);
            final long result = stepErrorRef.getId();
            tx.commit();
            return result;
        } catch (final RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    // =====================================================================
    // === Global Flow Parameters Management
    // =====================================================================

    public List<GlobalFlowParam> getGlobalFlowParameters(final short flowType) {
        /*
         * final Session session = configAndFactory.getFactory()
         * .getCurrentSession(); final Transaction tx =
         * session.beginTransaction(); try { final Query query =
         * session.createSQLQuery( "select " +
         * "p.name, s.serviceName, s.interfaceName, p.idx " + "from FLOWREF f "
         * + "join FLOWSTEPREF s " + "on f.id = s.flowref_id " +
         * "join FLOWREF_PARAMNAMES p " + "on p.FLOWSTEPREF_id = s.id " +
         * "where " + "f.type=:type " + "and p.global = true " +
         * "order by s.id, p.idx ").setShort("type",
         * flowType).setResultTransformer(
         * Transformers.aliasToBean(GlobalFlowParam.class)); final
         * List<GlobalFlowParam> ret = query.list(); tx.commit(); return ret; }
         * catch (final RuntimeException e) {
         * configAndFactory.getFactory().getCurrentSession()
         * .getTransaction().rollback(); throw e; }
         */
        final List<GlobalFlowParam> result = FlowStepRefDAO.getInstance().getGlobalFlowParameters(
                flowType);

        return result;
    }

    public List<FlowWithParams> getFlowsWithParameters(final List<GlobalFlowParam> globalParams,
            final short type, final Date after, final Date before) {
        // Construction de la requete :
        /*
         * final StringBuffer queryBuf = new StringBuffer();
         * queryBuf.append("select");queryBuf.append(
         * " f.id,f.idpetals, ffs.startDate, lfs.endDate, lfs.status "); for
         * (int i = 0; i < globalParams.size(); i++){ queryBuf.append(", p" + i
         * + ".element " ); } queryBuf.append(" from FLOW f "); String
         * currentService = null; String currentInterface = null; int srvIdx =
         * -1; for (int i = 0; i < globalParams.size(); i++) { final
         * GlobalFlowParam curParam = globalParams.get(i); if
         * (!curParam.getInterfaceName().equals(currentInterface) ||
         * !curParam.getServiceName().equals(currentService)) { // --- open a
         * left join for the service srvIdx++; currentInterface =
         * curParam.getInterfaceName(); currentService =
         * curParam.getServiceName(); queryBuf.append(" left join FLOWSTEP s" +
         * srvIdx); queryBuf.append(" on s" + srvIdx +
         * ".flow_id = f.idpetals and s" + srvIdx + ".serviceName = \"" +
         * curParam.getServiceName() + "\" and s" + srvIdx +
         * ".interfaceName = \"" + curParam.getInterfaceName() + "\""); } // ---
         * left join the parameter queryBuf.append(" left join FLOW_PARAMS p" +
         * i); queryBuf.append(" on p" + i + ".FLOWSTEP_id = s" + srvIdx +
         * ".id and p" + i + ".idx = " + curParam.getIdx() ); }
         * queryBuf.append(" left join FLOWREF fr ");
         * queryBuf.append(" on fr.type = "+type);
         * queryBuf.append(" left join FLOWSTEPREF ffsr ");queryBuf.append(
         * "on fr.id = ffsr.flowref_id and ffsr.flowstartstep = true ");
         * queryBuf.append("left join FLOWSTEP ffs ");queryBuf.append(
         * "on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName and ffs.interfaceName = ffsr.interfaceName "
         * ); queryBuf.append("left join FLOWSTEPREF lfsr ");
         * queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = true "
         * ); queryBuf.append("left join FLOWSTEP lfs ");queryBuf.append(
         * "on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName and lfs.interfaceName = lfsr.interfaceName "
         * ); queryBuf.append(" where f.type = "+type); if(before !=null ||
         * after !=null){ queryBuf.append(" and ffs.startdate is not null "); }
         * if(before !=null){ Timestamp beforeTsp = new Timestamp
         * (before.getTime());
         * queryBuf.append(" and ffs.startdate < '"+beforeTsp+"'"); } if(after
         * !=null){ Timestamp afterTsp = new Timestamp (after.getTime());
         * queryBuf.append(" and ffs.startdate > '"+afterTsp+"' "); }
         * queryBuf.append(" order by ffs.startdate"); final
         * List<FlowWithParams> ret = new ArrayList<FlowWithParams>();
         * FlowWithParams flowWithParams; List<String> listElements = null;
         * final String requete = queryBuf.toString();
         * //System.out.println(requete); StatelessSession sess =
         * configAndFactory.getFactory().openStatelessSession(); Connection con
         * ; try{ con = sess.connection(); final Statement stt =
         * con.createStatement(); final ResultSet rs =
         * stt.executeQuery(requete); while(rs.next()) { flowWithParams = new
         * FlowWithParams(); flowWithParams.setId(rs.getLong(1));
         * flowWithParams.setIdpetals(rs.getString(2));
         * flowWithParams.setStartDate(rs.getTimestamp(3));
         * flowWithParams.setEndDate(rs.getTimestamp(4));
         * flowWithParams.setStatus(rs.getInt(5)); listElements = new
         * ArrayList<String>(); for (int i = 0; i < globalParams.size(); i++) {
         * final String element = rs.getString(i+5); listElements.add(element);
         * } flowWithParams.setElement(listElements); ret.add(flowWithParams); }
         * stt.close(); sess.close(); }catch (final Exception e){
         * e.printStackTrace(); } if (ret != null) { for (FlowWithParams flow :
         * ret) { if (flow.getEndDate() == null) {
         * flow.setStatus(Integer.valueOf(-1)); } } } return ret;
         */

        final List<FlowWithParams> result = FlowStepRefDAO.getInstance().getFlowsWithParameters(
                globalParams, type, after, before);

        return result;
    }

    public List<FlowParamsDetails> getDetailFlowParameter(final short flowType, final String flowId) {

        final List<FlowParamsDetails> result = FlowStepRefDAO.getInstance().getDetailFlowParameter(
                flowType, flowId);

        return result;
    }
}
