/**
 * Flowwatch
 * -------------------------------------------------------------------------
 * RequestOptionsTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.flowwatch.flowmanager;

import java.util.ArrayList;
import java.util.List;

/**
 * Defines options for requesting Flowwatch database.
 * <p>
 * This allows defining "sort", "pagination" and "case sensitive" and "filter"
 * options when requesting the Flowwatch database
 * </p>
 * 
 * @author ofabre - eBM Websourcing
 */
public class RequestOptions {
    private int firstResult = 0;

    private int nbOfResults = Integer.MAX_VALUE;

    private int sortCriteria = -1;

    private boolean sortAscendingly = true;

    private List<Filter> filters;

    /**
     * Returns the requested first result index.
     * <p>
     * This the pagination offset
     * </p>
     * 
     * @return
     */
    public int getFirstResult() {
        return this.firstResult;
    }

    /**
     * Returns the requested number of results.
     * <p>
     * This the pagination length
     * </p>
     * 
     * @return
     */
    public int getNbOfResults() {
        return this.nbOfResults;
    }

    /**
     * Returns the sort criteria ID
     * 
     * @return
     */
    public int getSortCriteria() {
        return this.sortCriteria;
    }

    /**
     * Determines whether pagination options are set
     * 
     * @return
     */
    public boolean hasPagination() {
        return this.nbOfResults != Integer.MAX_VALUE;
    }

    /**
     * Determines whether sort options are set
     * 
     * @return
     */
    public boolean hasSortOption() {
        return !(this.sortCriteria < 0);
    }

    /**
     * Determines whether filter options are set
     * 
     * @return
     */
    public boolean hasFilterOption() {
        return this.filters != null && !this.filters.isEmpty();
    }

    /**
     * Determines whether sort is ascending.
     * 
     * @return
     */
    public boolean isSortAscendingly() {
        return this.sortAscendingly;
    }

    /**
     * Sets the requested first result index.
     * 
     * @param firstResult
     */
    public void setFirstResult(final int firstResult) {
        this.firstResult = firstResult;
    }

    /**
     * Sets the requested number of results.
     * 
     * @param nbOfResults
     */
    public void setNbOfResults(final int nbOfResults) {
        this.nbOfResults = nbOfResults;
    }

    /**
     * Sets whether sort is ascending.
     * 
     * @param sortAscendingly
     */
    public void setSortAscendingly(final boolean sortAscendingly) {
        this.sortAscendingly = sortAscendingly;
    }

    /**
     * Sets the sort criteria ID
     * 
     * @param sortColumn
     */
    public void setSortCriteria(final int sortColumn) {
        this.sortCriteria = sortColumn;
    }

    public List<Filter> getFilters() {
        return filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void addFilter(Filter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        filters.add(filter);
    }

}
