
package org.ow2.petals.flowwatch.flowmanager.bo;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * This class represents a functional flow definition.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@Entity
@Table(name = "FLOWREF")
@NamedQueries( {
        @NamedQuery(name = "FlowRef.getAll", query = "select o from FlowRef o"),
        @NamedQuery(name = "FlowRef.getById", query = "select o from FlowRef o where o.id = :id"),
        @NamedQuery(name = "FlowRef.getByType", query = "select o from FlowRef o where o.type = :type") })
public class FlowRef implements Serializable {

    /**
	 * 
	 */
    private static final long serialVersionUID = 8416940635043610355L;

    // ========================================================================
    // === Attributes
    // ========================================================================
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private long id;

    @Column()
    @Temporal(TemporalType.TIMESTAMP)
    private Date creationDate;

    @Column(unique = true)
    private int type;

    @Column(unique = true)
    private String name;

    // ========================================================================
    // === Constructors
    // ========================================================================

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

}
