
package org.ow2.petals.flowwatch.flowmanager.bo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.IndexColumn;

/**
 * This class represents a functional flow step instance in Petals.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@Entity
@Table(name = "FLOWSTEP")
@NamedQueries( {
        @NamedQuery(name = "FlowStep.getByFlowId", query = "select o from FlowStep o where o.flow.id = :id order by startDate"),
        @NamedQuery(name = "FlowStep.getById", query = "select o from FlowStep o where o.id = :id"),
        @NamedQuery(name = "FlowStep.getAll", query = "select o from FlowStep o"),
        @NamedQuery(name = "FlowStep.getByMeUUID", query = "select o from FlowStep o where o.meUUID = :meUUID"),
        @NamedQuery(name = "FlowStep.getRunningByFlowId", query = "select o from FlowStep o where o.flow.id = :id and o.status = 2") })
public class FlowStep implements Serializable {

    private static final long serialVersionUID = 5234804409942965567L;

    // ========================================================================
    // === Attributes
    // ========================================================================
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private long id;

    @Column
    private String interfaceName;

    @Column
    private String serviceName;

    @Column
    private String endpointName;

    @Column(unique = true, nullable = false)
    @Index(name = "meUUIDindex")
    private String meUUID;

    @Column()
    @Temporal(TemporalType.TIMESTAMP)
    private Date startDate;

    @Column()
    @Temporal(TemporalType.TIMESTAMP)
    private Date endDate;

    @Column()
    private int status;

    @Column()
    private int errorCode;

    @CollectionOfElements(fetch = FetchType.EAGER)
    @JoinTable(name = "FLOW_PARAMS")
    @IndexColumn(name = "idx")
    @ForeignKey(name = "FK_FLOWPARAMS_id_FLOW")
    private List<String> parameters;

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "flow_id", nullable = false, updatable = false, referencedColumnName = "idpetals")
    @ForeignKey(name = "FK_FLOW_id_FLOWSTEP_flow")
    private Flow flow;

    // ========================================================================
    // === Constructors
    // ========================================================================
    public FlowStep() {
    }

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================
    public long getId() {
        return this.id;
    }

    public void setId(final long id) {
        this.id = id;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(final int status) {
        this.status = status;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(final String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(final String serviceName) {
        this.serviceName = serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(final String endpointName) {
        this.endpointName = endpointName;
    }

    public String getMeUUID() {
        return this.meUUID;
    }

    public void setMeUUID(final String meUUID) {
        this.meUUID = meUUID;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(final Flow flow) {
        this.flow = flow;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(final int errorCode) {
        this.errorCode = errorCode;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(final List<String> parameters) {
        this.parameters = parameters;
    }

}
