
package org.ow2.petals.flowwatch.flowmanager.bo;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.ForeignKey;

/**
 * This class represents a functional flow step error definition.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@Entity
@Table(name = "FLOWSTEPERRORREF", uniqueConstraints = { @UniqueConstraint(columnNames = {
        "flowstepref_id", "errorCode" }) })
@NamedQueries( {
        @NamedQuery(name = "FlowStepErrorRef.getByStepRefId", query = "select o from FlowStepErrorRef o where o.flowstepref.id = :id order by errorCode"),
        @NamedQuery(name = "FlowStepErrorRef.getById", query = "select o from FlowStepErrorRef o where o.id = :id") })
public class FlowStepErrorRef implements Comparable<FlowStepErrorRef>, Serializable {
    /**
	 * 
	 */
    private static final long serialVersionUID = 1115146910203142614L;

    // ========================================================================
    // === Attributes
    // ========================================================================
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private long id;

    @Column
    private int errorCode;

    @Column
    private String message;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "flowstepref_id")
    @ForeignKey(name = "FK_FLOWSTEPREF_id_FLOWSTEP")
    private FlowStepRef flowstepref;

    // ========================================================================
    // === Constructors
    // ========================================================================
    public FlowStepErrorRef() {
    }

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================
    public long getId() {
        return this.id;
    }

    public void setId(final long id) {
        this.id = id;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(final int errorCode) {
        this.errorCode = errorCode;
    }

    public FlowStepRef getFlowStepRef() {
        return this.flowstepref;
    }

    public void setFlowStepRef(final FlowStepRef flowstepref) {
        this.flowstepref = flowstepref;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(final String message) {
        this.message = message;
    }

    public int compareTo(final FlowStepErrorRef obj) {
        if (this.equals(obj)) {
            return 0;
        }
        return Integer.valueOf(this.getErrorCode()).compareTo(Integer.valueOf(obj.getErrorCode()));
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object obj) {
        if (obj != null && obj instanceof FlowStepErrorRef) {
            if (this.getErrorCode() == ((FlowStepErrorRef) obj).getErrorCode()) {
                return true;
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return this.getErrorCode();
    }
}
