
package org.ow2.petals.flowwatch.flowmanager.bo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.IndexColumn;

/**
 * This class represents a functional flow step definition.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@Entity
@Table(name = "FLOWSTEPREF", uniqueConstraints = {
        @UniqueConstraint(columnNames = { "flowref_id", "name" }),
        @UniqueConstraint(columnNames = { "flowref_id", "interfaceName", "serviceName" }) })
@NamedQueries( {
        @NamedQuery(name = "FlowStepRef.getById", query = "select o from FlowStepRef o where o.id = :id"),
        @NamedQuery(name = "FlowStepRef.getByType", query = "select o from FlowStepRef o where o.flowref.type = :type"),
        @NamedQuery(name = "FlowStepRef.getStartStepByFlowType", query = "select o from FlowStepRef o where o.flowref.type = :type and o.flowStartStep = :start"),
        @NamedQuery(name = "FlowStepRef.getEndStepByFlowType", query = "select o from FlowStepRef o where o.flowref.type = :type and o.flowEndStep = :end"),
        @NamedQuery(name = "FlowStepRef.getByTypeIntNameServName", query = "select o from FlowStepRef o where o.flowref.type = :type and o.interfaceName = :interfaceName and o.serviceName = :serviceName") })
public class FlowStepRef implements Serializable {
    /**
	 * 
	 */
    private static final long serialVersionUID = -4099365746136084661L;

    // ========================================================================
    // === Attributes
    // ========================================================================
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private long id;

    @Column
    private String interfaceName;

    @Column
    private String serviceName;

    @Column()
    private String name;

    @Column
    private boolean flowStartStep;

    @Column
    private boolean flowEndStep;

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "flowref_id", nullable = false, updatable = false)
    @ForeignKey(name = "FK_FLOWREF_id_FLOWSTEPREF_flowref")
    private FlowRef flowref;

    // FIXME Cette classe Serializable définit un champ d'instance non primitif
    // qui n'est ni transient, ni Serializable ou java.lang.Object, et qui ne
    // semble pas implémenter l'interface Externalizable ou les méthodes
    // readObject() et writeObject(). Les objets de cette classe ne seront pas
    // désérialisés correctement si un
    // objet non Serializable est stocké dans ce champ
    @OneToMany(mappedBy = "flowstepref", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    @MapKey(name = "errorCode")
    private Map<Integer, FlowStepErrorRef> errorMessages;

    @Column()
    private String successMessage;

    @Column()
    private String defaultErrorMessage;

    @CollectionOfElements(fetch = FetchType.EAGER)
    @JoinTable(name = "FLOWREF_PARAMNAMES")
    @IndexColumn(name = "idx")
    @ForeignKey(name = "FK_PARAMNAMES_id_FLOWREF")
    private List<StepParameter> parameterNames;

    // ========================================================================
    // === Constructors
    // ========================================================================
    public FlowStepRef() {
        this.parameterNames = new ArrayList<StepParameter>();
    }

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================
    public long getId() {
        return this.id;
    }

    public boolean isFlowStartStep() {
        return this.flowStartStep;
    }

    public void setFlowStartStep(final boolean flowStartStep) {
        this.flowStartStep = flowStartStep;
    }

    public boolean isFlowEndStep() {
        return this.flowEndStep;
    }

    public void setFlowEndStep(final boolean flowEndStep) {
        this.flowEndStep = flowEndStep;
    }

    public void setId(final long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(final String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(final String serviceName) {
        this.serviceName = serviceName;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public FlowRef getFlowref() {
        return this.flowref;
    }

    public void setFlowref(final FlowRef flowref) {
        this.flowref = flowref;
    }

    public Map<Integer, FlowStepErrorRef> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(final Map<Integer, FlowStepErrorRef> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(final String successMessage) {
        this.successMessage = successMessage;
    }

    public String getDefaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    public void setDefaultErrorMessage(final String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public List<StepParameter> getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(final List<StepParameter> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public void addParameterName(final StepParameter parameterName) {
        this.parameterNames.add(parameterName);
    }

    public void addParameterName(final int index, final StepParameter parameterName) {
        this.parameterNames.add(index, parameterName);
    }

    public void updateParameterName(final int index, final StepParameter parameterName) {
        this.parameterNames.set(index, parameterName);
    }

    public void removeParameterName(final int index) {
        this.parameterNames.remove(index);
    }

}
