
package org.ow2.petals.flowwatch.flowmanager.dao;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.transform.Transformers;
import org.ow2.petals.flowwatch.flowmanager.CreateSqLQueryFlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.CreateSqlQueryFlow;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import com.trg.search.Search;

public class FlowDAO extends AbstractFlowDAO<Flow, String> {

    public FlowDAO() {
        super();
    }

    public Flow loadByPetalsId(final String petalsId) {
        final Search search = new Search();
        final Flow flow = this.searchUnique(search.addFilterEqual("idpetals", petalsId));
        return flow;
    }

    public List<Flow> loadAllStarted() {
        return this.search(new Search().addFilterNotNull("startDate").addSortDesc("startDate"));
    }

    public List<Flow> loadByType(final int type) {
        return this.search(new Search().addFilterEqual("type", type));
    }

    public List<Flow> loadAllStartedByType(final int type) {
        return this.search(new Search().addFilterEqual("type", type).addFilterNotNull("startDate")
                .addSortDesc("startDate"));
    }

    public List<Flow> loadAllStartedByTypeWithDateFilter(final int type, final Date after,
            final Date before) {
        final Search search = new Search();
        search.addFilterNotNull("startDate");
        search.addFilterEqual("type", type);
        search.addSortDesc("startDate");
        if (after != null) {
            search.addFilterGreaterOrEqual("startDate", after);
        }
        if (before != null) {
            search.addFilterLessOrEqual("startDate", before);
        }
        return this.search(search);
    }

    public int countAllFlows(Date after, Date before, RequestOptions requestOptions) {

        CreateSqlQueryFlow queryFlow = new CreateSqlQueryFlow();
        String query = queryFlow.createCountQuery(after, before, requestOptions);
//        final Session session = this.getSession();
//        final Transaction tx = session.beginTransaction();

//        final long countTmp = (Long) session.createSQLQuery(query).uniqueResult();

//        int count = (int) countTmp;
        
        int count = getCount(query);
//        tx.commit();
        return count;
    }

    public int countAllFlowsByType(Date after, Date before, List<GlobalFlowParam> globalParams,
            final short flowType, RequestOptions requestOptions) {

        CreateSqLQueryFlowWithParams queryFlowWithParams = new CreateSqLQueryFlowWithParams();
        String query = queryFlowWithParams.createCountQuery(after, before, globalParams, flowType,
                requestOptions);
//        final Session session = this.getSession();
//        final Transaction tx = session.beginTransaction();
//
//        final long countTmp = (Long) session.createSQLQuery(query).uniqueResult();
//
//        int count = (int) countTmp;
        
        int count = getCount(query);
//        tx.commit();
        return count;
    }

    @SuppressWarnings("unchecked")
    public List<Flow> getAllFlows(Date after, Date before, RequestOptions requestOptions) {

        CreateSqlQueryFlow queryFlow = new CreateSqlQueryFlow();
        String query = queryFlow.createGetQuery(after, before, requestOptions);

        final Session session = this.getSession();
        final Transaction tx = session.beginTransaction();

        List<Flow> result = new ArrayList<Flow>();

        final Query q = session.createSQLQuery(query).setResultTransformer(
                Transformers.aliasToBean(Flow.class));
        if (q != null) {
            result = q.list();

            if (result != null) {
                for (final Flow flow : result) {
                    if (flow.getEndDate() == null) {
                        flow.setStatus(Integer.valueOf(-1));
                    }
                }
            }
        }
        tx.commit();
        return result;
    }

    public List<FlowWithParams> getAllFlowsByType(Date after, Date before,
            List<GlobalFlowParam> globalParams, final short flowType, RequestOptions requestOptions) {

        CreateSqLQueryFlowWithParams queryFlowWithParams = new CreateSqLQueryFlowWithParams();
        String query = queryFlowWithParams.createGetQuery(after, before, globalParams, flowType,
                requestOptions);
        // System.out.println(query);
        Statement stt = null;
        StatelessSession sess = null;
        Connection con = null;

        final List<FlowWithParams> ret = new ArrayList<FlowWithParams>();
        FlowWithParams flowWithParams;
        List<String> listElements = null;

        sess = this.getSessionFactory().openStatelessSession();

        try {
            con = sess.connection();
            stt = con.createStatement();
            final Transaction tx = sess.beginTransaction();
            final ResultSet rs = stt.executeQuery(query);

            while (rs.next()) {
                flowWithParams = new FlowWithParams();

                flowWithParams.setId(rs.getLong(1));
                flowWithParams.setIdpetals(rs.getString(2));
                flowWithParams.setStartDate(rs.getTimestamp(3));
                flowWithParams.setEndDate(rs.getTimestamp(4));
                flowWithParams.setStatus(rs.getInt(5));

                listElements = new ArrayList<String>();
                for (int i = 0; i < globalParams.size(); i++) {

                    final String element = rs.getString(i + 6);
                    listElements.add(element);
                }
                flowWithParams.setElement(listElements);

                ret.add(flowWithParams);
            }
            tx.commit();
        } catch (final Throwable t) {
            t.printStackTrace();
        } finally {
            if (stt != null) {
                try {
                    stt.close();
                } catch (final SQLException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                } catch (final SQLException e) {
                    e.printStackTrace();
                }
            }
            if (sess != null) {
                sess.close();
            }
        }
        if (ret != null) {
            for (final FlowWithParams flow : ret) {
                if (flow.getEndDate() == null) {
                    flow.setStatus(Integer.valueOf(-1));
                }
            }
        }

        return ret;
    }
    
    private int getCount(String query) {
      final Session session = this.getSession();
      final Transaction tx = session.beginTransaction();
        int count = 0;
        final Object countTmp = (Object) session.createSQLQuery(query).uniqueResult();

        if (countTmp instanceof BigInteger) // For PostgreSQL database
        {
            count = new Integer(((BigInteger) countTmp).intValue());
        }
        if (countTmp instanceof Long) // For MySQL et H2 database
        {
            long result = (Long) countTmp;
            count = (int) result;
        }
        if (countTmp instanceof BigDecimal) // For Oracle database
        {
            count = new Integer(((BigDecimal) countTmp).intValue());
        }

      tx.commit();
        return count;
    }

}
