
package org.ow2.petals.flowwatch.flowmanager.dao;

import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.utils.HibernateUtils;

import com.trg.search.Search;

public class FlowRefDAO extends AbstractFlowDAO<FlowRef, Long> {

    private static FlowRefDAO instance = null;

    static {
        instance = new FlowRefDAO();
        instance.setSessionFactory(HibernateUtils.getConfigAndFactory().getFactory());
    }

    private FlowRefDAO() {
        super();
    }

    public static FlowRefDAO getInstance() {
        return instance;
    }

    public FlowRef loadByType(final int type) {
        return this.searchUnique(new Search().addFilterEqual("type", type));
    }

}
