
package org.ow2.petals.flowwatch.flowmanager.dao;

import java.util.List;

import org.ow2.petals.flowwatch.flowmanager.bo.FlowStep;
import com.trg.search.Search;

public class FlowStepDAO extends AbstractFlowDAO<FlowStep, Long> {

    public FlowStepDAO() {
        super();
    }

    public List<FlowStep> loadByFlowId(final String id) {
        return this.search(new Search().addFilterEqual("flow.idpetals", id).addSortAsc("endDate"));
    }

    public FlowStep loadByMeUUID(final String meUUID) {
        return this.searchUnique(new Search().addFilterEqual("meUUID", meUUID));
    }

    public List<FlowStep> loadByFlowIdAndMeProps(final String flowId, final String interfaceName,
            final String serviceName) {
        return this.search(new Search().addFilterEqual("flow.idpetals", flowId).addFilterEqual(
                "interfaceName", interfaceName).addFilterEqual("serviceName", serviceName));
    }

    public List<FlowStep> loadRunningByFlowId(final String id) {
        return this.search(new Search().addFilterEqual("flow.idpetals", id).addFilterEqual(
                "status", 2).addSortAsc("startDate"));
    }

}
