
package org.ow2.petals.flowwatch.flowmanager.dao;

import java.util.List;

import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.utils.HibernateUtils;

import com.trg.search.Search;

public class FlowStepErrorRefDAO extends AbstractFlowDAO<FlowStepErrorRef, Long> {

    private static FlowStepErrorRefDAO instance = null;

    static {
        instance = new FlowStepErrorRefDAO();
        instance.setSessionFactory(HibernateUtils.getConfigAndFactory().getFactory());
    }

    private FlowStepErrorRefDAO() {
        super();
    }

    public static FlowStepErrorRefDAO getInstance() {
        return instance;
    }

    public List<FlowStepErrorRef> loadByStepRefId(final long stepRefId) {
        return this.search(new Search().addFilterEqual("flowstepref.id", stepRefId).addSortAsc(
                "errorCode"));
    }
}
