
package org.ow2.petals.flowwatch.flowmanager.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.transform.Transformers;
import org.ow2.petals.flowwatch.flowmanager.FlowParamsDetails;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;
import org.ow2.petals.flowwatch.utils.HibernateUtils;

import com.trg.search.Search;

public class FlowStepRefDAO extends AbstractFlowDAO<FlowStepRef, Long> {

    private static FlowStepRefDAO instance = null;

    private FlowStepRefDAO() {
        super();
    }

    static {
        instance = new FlowStepRefDAO();
        instance.setSessionFactory(HibernateUtils.getConfigAndFactory().getFactory());
    }

    public static FlowStepRefDAO getInstance() {
        return instance;
    }

    public List<FlowStepRef> loadByFlowType(final int type) {
        return this.search(new Search().addFilterEqual("flowref.type", type));
    }

    public FlowStepRef loadStartStepByFlowType(final int type) {
        return this.searchUnique(new Search().addFilterEqual("flowref.type", type).addFilterEqual(
                "flowStartStep", true));
    }

    public FlowStepRef loadEndStepByFlowType(final int type) {
        return this.searchUnique(new Search().addFilterEqual("flowref.type", type).addFilterEqual(
                "flowEndStep", true));
    }

    public FlowStepRef loadByFlowTypeIntNameServName(final int type, final String interfaceName,
            final String serviceName) {
        return this.searchUnique(new Search().addFilterEqual("flowref.type", type).addFilterEqual(
                "interfaceName", interfaceName).addFilterEqual("serviceName", serviceName));
    }

    @SuppressWarnings("unchecked")
    public List<GlobalFlowParam> getGlobalFlowParameters(final short flowType) {
        final Session session = this.getSession();
        final Transaction tx = session.beginTransaction();
        try {
            final Query query = session.createSQLQuery(
                    "select " + "p.name, s.serviceName, s.interfaceName, p.idx "
                            + "from FLOWREF f " + "join FLOWSTEPREF s " + "on f.id = s.flowref_id "
                            + "join FLOWREF_PARAMNAMES p " + "on p.FLOWSTEPREF_id = s.id "
                            + "where " + "f.type=:type " + "and p.global = true "
                            + "order by s.id, p.idx ").setShort("type", flowType)
                    .setResultTransformer(Transformers.aliasToBean(GlobalFlowParam.class));

            final List<GlobalFlowParam> ret = query.list();
            tx.commit();
            return ret;
        } catch (final RuntimeException e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public List<FlowWithParams> getFlowsWithParameters(final List<GlobalFlowParam> globalParams,
            final short type, final Date after, final Date before) {
        Statement stt = null;
        StatelessSession sess = null;
        Connection con = null;

        // Construction de la requete :
        final StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("select");
        queryBuf.append(" f.id,f.idpetals, ffs.startDate, lfs.endDate, lfs.status ");
        for (int i = 0; i < globalParams.size(); i++) {
            queryBuf.append(", p" + i + ".element ");
        }
        queryBuf.append(" from FLOW f ");
        String currentService = null;
        String currentInterface = null;
        int srvIdx = -1;
        for (int i = 0; i < globalParams.size(); i++) {
            final GlobalFlowParam curParam = globalParams.get(i);
            if (!curParam.getInterfaceName().equals(currentInterface)
                    || !curParam.getServiceName().equals(currentService)) {
                // --- open a left join for the service
                srvIdx++;
                currentInterface = curParam.getInterfaceName();
                currentService = curParam.getServiceName();
                queryBuf.append(" left join FLOWSTEP s" + srvIdx);
                queryBuf.append(" on s" + srvIdx + ".flow_id = f.idpetals and s" + srvIdx
                        + ".serviceName = \"" + curParam.getServiceName() + "\" and s" + srvIdx
                        + ".interfaceName = \"" + curParam.getInterfaceName() + "\"");
            }
            // --- left join the parameter
            queryBuf.append(" left join FLOW_PARAMS p" + i);
            queryBuf.append(" on p" + i + ".FLOWSTEP_id = s" + srvIdx + ".id and p" + i + ".idx = "
                    + curParam.getIdx());

        }
        queryBuf.append(" left join FLOWREF fr ");
        queryBuf.append(" on fr.type = " + type);
        queryBuf.append(" left join FLOWSTEPREF ffsr ");
        queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = true ");
        queryBuf.append("left join FLOWSTEP ffs ");
        queryBuf
                .append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName and ffs.interfaceName = ffsr.interfaceName ");
        queryBuf.append("left join FLOWSTEPREF lfsr ");
        queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = true ");
        queryBuf.append("left join FLOWSTEP lfs ");
        queryBuf
                .append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName and lfs.interfaceName = lfsr.interfaceName ");
        queryBuf.append(" where f.type = " + type);

        if (before != null || after != null) {
            queryBuf.append(" and ffs.startdate is not null ");
        }

        if (before != null) {
            final Timestamp beforeTsp = new Timestamp(before.getTime());
            queryBuf.append(" and ffs.startdate < '" + beforeTsp + "'");
        }
        if (after != null) {
            final Timestamp afterTsp = new Timestamp(after.getTime());
            queryBuf.append(" and ffs.startdate > '" + afterTsp + "' ");
        }
        queryBuf.append(" order by ffs.startdate, lfs.status, f.id");
        final List<FlowWithParams> ret = new ArrayList<FlowWithParams>();
        FlowWithParams flowWithParams;
        List<String> listElements = null;
        final String requete = queryBuf.toString();
        sess = this.getSessionFactory().openStatelessSession();
        try {
            con = sess.connection();
            stt = con.createStatement();
            final ResultSet rs = stt.executeQuery(requete);

            while (rs.next()) {
                flowWithParams = new FlowWithParams();

                flowWithParams.setId(rs.getLong(1));
                flowWithParams.setIdpetals(rs.getString(2));
                flowWithParams.setStartDate(rs.getTimestamp(3));
                flowWithParams.setEndDate(rs.getTimestamp(4));
                flowWithParams.setStatus(rs.getInt(5));

                listElements = new ArrayList<String>();
                for (int i = 0; i < globalParams.size(); i++) {

                    final String element = rs.getString(i + 6);
                    listElements.add(element);
                }
                flowWithParams.setElement(listElements);

                ret.add(flowWithParams);
            }
        } catch (final Throwable t) {
            // TODO log me
        } finally {
            if (stt != null) {
                try {
                    stt.close();
                } catch (final SQLException e) {
                    // TODO log me
                }
            }
            if (con != null) {
                try {
                    con.close();
                } catch (final SQLException e) {
                    // TODO log me
                }
            }
            if (sess != null) {
                sess.close();
            }
        }
        if (ret != null) {
            for (final FlowWithParams flow : ret) {
                if (flow.getEndDate() == null) {
                    flow.setStatus(Integer.valueOf(-1));
                }
            }
        }

        return ret;
    }

    @SuppressWarnings("unchecked")
    public List<FlowParamsDetails> getDetailFlowParameter(final short flowType, final String flowId) {
        final Session session = this.getSession();
        final Transaction tx = session.beginTransaction();
        try {
            final Query query = session
                    .createSQLQuery(
                            "select pr.name, pr.idx, p.element "
                                    + " from FLOWREF fr "
                                    + " join FLOWSTEPREF sr "
                                    + " on fr.id = sr.flowref_id "
                                    + " join FLOWREF_PARAMNAMES pr "
                                    + " on pr.FLOWSTEPREF_id = sr.id "
                                    + " left join FLOWSTEP s "
                                    + "  on s.flow_id = '"
                                    + flowId
                                    + "' and s.serviceName = sr.serviceName and s.interfaceName = sr.interfaceName "
                                    + " left join FLOW_PARAMS p "
                                    + " on p.FLOWSTEP_id = s.id and p.idx = pr.idx " + " where "
                                    + " fr.type=:type " + " and pr.global = true "
                                    + " order by sr.id, pr.idx ;").setShort("type", flowType)
                    .setResultTransformer(Transformers.aliasToBean(FlowParamsDetails.class));

            final List<FlowParamsDetails> ret = query.list();

            tx.commit();
            return ret;

        } catch (final RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

}
