/**
 * 
 */

package org.ow2.petals.flowwatch.notification;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * This class is a mapping of a notification content
 * 
 * @author ofabre
 */
public class Notification {

    public static final String NOTIF_ELEM_NAME = "NotifyContent";

    public static final String PROCESS_ID_ATTR_NAME = "processPath";

    public static final String PROCESS_TYPE_ATTR_NAME = "processType";

    public static final String ENDPOINT_ATTR_NAME = "endpoint";

    public static final String INTERFACE_ATTR_NAME = "interface";

    public static final String SERVICE_ATTR_NAME = "service";

    public static final String MEUUID_ATTR_NAME = "meuuid";

    public static final String STATUS_ATTR_NAME = "status";

    public static final String NOTIF_DATE_ATTR_NAME = "notifDate";

    public static final String PARAMS_ELEM_NAME = "params";

    public static final String PARAM_ELEM_NAME = "param";

    /**
     * The process type
     */
    private int processType;

    /**
     * The process external identifier
     */
    private String processId;

    /**
     * The interface name associated with this step notif
     */
    private String interfaceName;

    /**
     * The interface name associated with this step notif
     */
    private String serviceName;

    /**
     * The interface name associated with this step notif
     */
    private String endpointName;

    /**
     * The interface name associated with this step notif
     */
    private String meUUID;

    /**
     * A notification status : IN_PROGRESS (-1), SUCCESS (0), FAILURE (code>0)
     */
    private int status;

    /**
     * Notification date
     */
    private Date notifDate;

    /**
     * The process input parameters
     */
    private List<String> params;

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("processType", this.processType).append(
                "processPaht", this.processId).append("interfaceName", this.interfaceName).append(
                "serviceName", this.serviceName).append("endpointName", this.endpointName).append(
                "meUUID", this.meUUID).append("status", this.status).append("notifDate",
                this.notifDate).append("params", this.params).toString();
    }

    public Notification() {
        super();
        this.params = new ArrayList<String>();
    }

    public void addParam(final String param) {
        this.params.add(param);
    }

    public int getProcessType() {
        return this.processType;
    }

    public void setProcessType(final int processType) {
        this.processType = processType;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(final String processId) {
        this.processId = processId;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(final String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(final String serviceName) {
        this.serviceName = serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(final String endpointName) {
        this.endpointName = endpointName;
    }

    public String getMeUUID() {
        return this.meUUID;
    }

    public void setMeUUID(final String meUUID) {
        this.meUUID = meUUID;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(final int status) {
        this.status = status;
    }

    public Date getNotifDate() {
        return this.notifDate;
    }

    public void setNotifDate(final Date notifDate) {
        this.notifDate = notifDate;
    }

    public List<String> getParams() {
        return this.params;
    }

    public void setParams(final List<String> params) {
        this.params = params;
    }

    public boolean isValid() {
        boolean validated = true;
        // required parameters
        if (this.processId == null || this.processId.length() == 0) {
            validated = false;
        } else if (this.meUUID == null || this.meUUID.length() == 0) {
            validated = false;
        }
        return validated;
    }

}
