/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */

package org.ow2.petals.flowwatch.utils;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;

/**
 * @author Frederic Gardes
 */
public class ConfigAndFactory {
    private AnnotationConfiguration config = null;

    private SessionFactory factory = null;

    /**
     * Get the config
     * 
     * @return the config
     */
    public AnnotationConfiguration getConfig() {
        return this.config;
    }

    /**
     * Set the config
     * 
     * @param config
     *            the config to set
     */
    public void setConfig(final AnnotationConfiguration config) {
        this.config = config;
        this.factory = config.buildSessionFactory();
    }

    /**
     * Get the factory
     * 
     * @return the factory
     */
    public SessionFactory getFactory() {
        return this.factory;
    }
}
