
package org.ow2.petals.flowwatch.utils;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;
import org.hibernate.cfg.AnnotationConfiguration;

public class HibernateUtils {

    private static ConfigAndFactory configAndFactory = null;

    private static Logger logger = Logger.getLogger(HibernateUtils.class);

    static {
        // Java property
        URL configUrl = null;
        if (System.getProperty("hibernate.default.config") != null) {
            try {
                configUrl = new URL(System.getProperty("hibernate.default.config"));
                // ok, this is a valid url
            } catch (final MalformedURLException e) {
                logger.warn("Default hibernate url not valid.", e);
            }
        }
        // creation
        configAndFactory = new ConfigAndFactory();
        final AnnotationConfiguration annotationConfiguration = new AnnotationConfiguration();
        if (configUrl == null) {
            annotationConfiguration.configure();
        } else {
            annotationConfiguration.configure(configUrl);
        }
        configAndFactory.setConfig(annotationConfiguration);
    }

    public static ConfigAndFactory getConfigAndFactory() {
        return configAndFactory;
    }
}
