/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.flowmanager;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.ow2.petals.flowwatch.flowmanager.AbstractCreateSQLQuery;
import org.ow2.petals.flowwatch.flowmanager.Filter;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSqLQueryFlowWithParams
extends AbstractCreateSQLQuery {
    @Override
    protected String getSelectByAttribute() {
        return "select f.id,f.idpetals, ffs.startDate, lfs.endDate, lfs.status ";
    }

    private String getWhereFlowTypeClause(String type) {
        return " where f.type = " + type;
    }

    protected String getWhereDateClause(Date after, Date before) {
        StringBuffer queryBuf = new StringBuffer();
        if (before != null || after != null) {
            queryBuf.append(" and ffs.startdate is not null ");
        }
        if (before != null) {
            Timestamp beforeTsp = new Timestamp(before.getTime());
            queryBuf.append(" and ffs.startdate < '" + beforeTsp + "'");
        }
        if (after != null) {
            Timestamp afterTsp = new Timestamp(after.getTime());
            queryBuf.append(" and ffs.startdate > '" + afterTsp + "' ");
        }
        return queryBuf.toString();
    }

    private String getSelectParam(List<GlobalFlowParam> globalParams) {
        StringBuffer queryBuf = new StringBuffer();
        for (int i = 0; i < globalParams.size(); ++i) {
            queryBuf.append(" , p" + i + ".element ");
        }
        return queryBuf.toString();
    }

    private String getParamStepLeftJoin(List<GlobalFlowParam> globalParams) {
        StringBuffer queryBuf = new StringBuffer();
        String currentService = null;
        String currentInterface = null;
        int srvIdx = -1;
        for (int i = 0; i < globalParams.size(); ++i) {
            GlobalFlowParam curParam = globalParams.get(i);
            if (!curParam.getInterfaceName().equals(currentInterface) || !curParam.getServiceName().equals(currentService)) {
                currentInterface = curParam.getInterfaceName();
                currentService = curParam.getServiceName();
                queryBuf.append(" left join FLOWSTEP s" + ++srvIdx);
                queryBuf.append(" on s" + srvIdx + ".flow_id = f.idpetals and s" + srvIdx + ".serviceName = '" + curParam.getServiceName() + "' and s" + srvIdx + ".interfaceName = '" + curParam.getInterfaceName() + "'");
            }
            queryBuf.append(" left join FLOW_PARAMS p" + i);
            queryBuf.append(" on p" + i + ".FLOWSTEP_id = s" + srvIdx + ".id and p" + i + ".idx = " + curParam.getIdx());
        }
        return queryBuf.toString();
    }

    @Override
    protected String sort(int idxColumn, String sortType) {
        String sort = null;
        switch (idxColumn) {
            case 0: {
                sort = " order by f.id " + sortType + " ";
                break;
            }
            case 1: {
                sort = " order by  ffs.startdate " + sortType + " ";
                break;
            }
            case 2: {
                sort = " order by  lfs.endDate " + sortType + " ";
                break;
            }
            case 3: {
                sort = " order by lfs.status " + sortType + " ";
                break;
            }
            default: {
                sort = " order by p" + (idxColumn - 4) + ".element " + sortType + " ";
            }
        }
        return sort;
    }

    private String getWhereFilterClose(List<Filter> allFilters) {
        String filter1 = "";
        String filter2 = "";
        String filter3 = "";
        for (int i = 0; i < allFilters.size(); ++i) {
            if (allFilters.get(i).getIndexColumn() == 3) {
                String value = allFilters.get(i).getValue();
                if (value.equals("2")) {
                    filter3 = " and (lfs.endDate is null or lfs.status = -1 )";
                } else if (value.equals("1")) {
                    value = " >0";
                    filter3 = " and lfs.status " + value;
                } else {
                    value = " = 0";
                    filter3 = " and lfs.status " + value;
                }
                filter3 = filter3 + filter2;
                continue;
            }
            int idx = allFilters.get(i).getIndexColumn() - 4;
            String value = allFilters.get(i).getValue();
            Filter.FilterType type = allFilters.get(i).getType();
            String mysqltype = this.getMySQLFilterType(type, value);
            filter1 = " and p" + idx + ".element " + mysqltype;
            filter2 = filter2 + filter1;
        }
        return filter3 + filter1;
    }

    public String createGetQuery(Date after, Date before, List<GlobalFlowParam> globalParams, short flowType, RequestOptions reqOpt) {
        String sql = this.getSelectByAttribute() + this.getSelectParam(globalParams) + this.getFrom();
        sql = sql + this.getFlowRefLeftJoinByType(String.valueOf(flowType)) + this.getStartStepLeftJoin() + this.getLastStepLeftJoin() + this.getParamStepLeftJoin(globalParams);
        sql = sql + this.getWhereFlowTypeClause(String.valueOf(flowType));
        sql = sql + this.getWhereDateClause(after, before);
        if (reqOpt.hasFilterOption()) {
            sql = sql + this.getWhereFilterClose(reqOpt.getFilters());
        }
        sql = reqOpt.hasSortOption() ? (reqOpt.isSortAscendingly() ? sql + this.sortAsc(reqOpt.getSortCriteria()) : sql + this.sortDesc(reqOpt.getSortCriteria())) : sql + this.getGlobalOrderBy();
        if (reqOpt.hasPagination()) {
            sql = sql + this.getLimit(reqOpt.getFirstResult(), reqOpt.getNbOfResults());
        }
        return sql;
    }

    public String createCountQuery(Date after, Date before, List<GlobalFlowParam> globalParams, short flowType, RequestOptions reqOpt) {
        String sql = this.getSelectForCount() + this.getFrom();
        if (after != null || before != null) {
            if (reqOpt.hasFilterOption()) {
                sql = sql + this.getFlowRefLeftJoinGlobal() + this.getStartStepLeftJoin() + this.getLastStepLeftJoin() + this.getParamStepLeftJoin(globalParams);
                sql = sql + this.getWhereFlowTypeClause(String.valueOf(flowType));
                sql = sql + this.getWhereDateClause(after, before);
                sql = sql + this.getWhereFilterClose(reqOpt.getFilters());
            } else {
                sql = sql + this.getFlowRefLeftJoinGlobal() + this.getStartStepLeftJoin();
                sql = sql + this.getWhereFlowTypeClause(String.valueOf(flowType));
                sql = sql + this.getWhereDateClause(after, before);
            }
        } else if (reqOpt.hasFilterOption()) {
            sql = sql + this.getFlowRefLeftJoinGlobal() + this.getLastStepLeftJoin() + this.getParamStepLeftJoin(globalParams);
            sql = sql + this.getWhereFlowTypeClause(String.valueOf(flowType));
            sql = sql + this.getWhereFilterClose(reqOpt.getFilters());
        } else {
            sql = sql + this.getWhereFlowTypeClause(String.valueOf(flowType));
        }
        return sql;
    }
}

