/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.flowmanager;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.ow2.petals.flowwatch.flowmanager.AbstractCreateSQLQuery;
import org.ow2.petals.flowwatch.flowmanager.Filter;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSqlQueryFlow
extends AbstractCreateSQLQuery {
    @Override
    protected String getSelectByAttribute() {
        return "select f.id,f.idpetals, ffs.startDate, lfs.endDate, f.type, lfs.status ";
    }

    @Override
    protected String sort(int idxColumn, String sortType) {
        String sort = null;
        switch (idxColumn) {
            case 0: {
                sort = " order by f.type " + sortType + " ";
                break;
            }
            case 1: {
                sort = " order by f.id " + sortType + " ";
                break;
            }
            case 2: {
                sort = " order by  ffs.startdate " + sortType + " ";
                break;
            }
            case 3: {
                sort = " order by  lfs.endDate " + sortType + " ";
                break;
            }
            case 4: {
                sort = " order by lfs.status " + sortType + " ";
            }
        }
        return sort;
    }

    protected String getWhereDateClause(Date after, Date before) {
        StringBuffer queryBuf = new StringBuffer();
        if (before != null || after != null) {
            queryBuf.append("where ffs.startdate is not null ");
        }
        if (before != null) {
            Timestamp beforeTsp = new Timestamp(before.getTime());
            queryBuf.append(" and ffs.startdate < '" + beforeTsp + "'");
        }
        if (after != null) {
            Timestamp afterTsp = new Timestamp(after.getTime());
            queryBuf.append(" and ffs.startdate > '" + afterTsp + "' ");
        }
        return queryBuf.toString();
    }

    private String getWhereFilterClose(List<Filter> allFilters, Date after, Date before) {
        String filter1 = "";
        String filter3 = "";
        String where = "";
        where = before == null && after == null ? " where " : " and ";
        for (int i = 0; i < allFilters.size(); ++i) {
            String value;
            if (allFilters.get(i).getIndexColumn() == 0) {
                value = allFilters.get(i).getValue();
                filter1 = " f.type = " + value + " and ";
            }
            if (allFilters.get(i).getIndexColumn() != 4) continue;
            value = allFilters.get(i).getValue();
            if (value.equals("2")) {
                filter3 = " ( lfs.endDate is null or lfs.status = -1 ) ";
            } else if (value.equals("1")) {
                value = " >0";
                filter3 = " lfs.status " + value;
            } else {
                value = " = 0";
                filter3 = " lfs.status " + value;
            }
            filter3 = filter3 + " and ";
        }
        String result = where + filter1 + filter3;
        return result.substring(0, result.length() - 5);
    }

    public String createGetQuery(Date after, Date before, RequestOptions reqOpt) {
        String sql = this.getSelectByAttribute() + this.getFrom();
        sql = sql + this.getFlowRefLeftJoinGlobal() + this.getStartStepLeftJoin() + this.getLastStepLeftJoin();
        sql = sql + this.getWhereDateClause(after, before);
        if (reqOpt.hasFilterOption()) {
            sql = sql + this.getWhereFilterClose(reqOpt.getFilters(), after, before);
        }
        sql = reqOpt.hasSortOption() ? (reqOpt.isSortAscendingly() ? sql + this.sortAsc(reqOpt.getSortCriteria()) : sql + this.sortDesc(reqOpt.getSortCriteria())) : sql + this.getGlobalOrderBy();
        if (reqOpt.hasPagination()) {
            sql = sql + this.getLimit(reqOpt.getFirstResult(), reqOpt.getNbOfResults());
        }
        return sql;
    }

    public String createCountQuery(Date after, Date before, RequestOptions reqOpt) {
        String sql = this.getSelectForCount() + this.getFrom();
        if (after != null || before != null) {
            if (reqOpt.hasFilterOption()) {
                sql = sql + this.getFlowRefLeftJoinGlobal() + this.getStartStepLeftJoin() + this.getLastStepLeftJoin();
                sql = sql + this.getWhereDateClause(after, before);
                sql = sql + this.getWhereFilterClose(reqOpt.getFilters(), after, before);
            } else {
                sql = sql + this.getFlowRefLeftJoinGlobal() + this.getStartStepLeftJoin();
                sql = sql + this.getWhereDateClause(after, before);
            }
        } else if (reqOpt.hasFilterOption()) {
            sql = sql + this.getFlowRefLeftJoinGlobal() + this.getLastStepLeftJoin();
            sql = sql + this.getWhereFilterClose(reqOpt.getFilters(), after, before);
        }
        return sql;
    }
}

