/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.flowmanager;

import java.util.Date;
import java.util.List;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.ow2.petals.flowwatch.flowmanager.ConfigAndFactoryManager;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStep;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowDAO;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowStepDAO;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowStepRefDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowManager
extends ConfigAndFactoryManager {
    private static FlowManager instance;
    private static FlowDAO flowDAO;
    private static FlowStepDAO flowStepDAO;
    private static FlowStepRefDAO flowStepRefDAO;

    public static FlowManager getInstance() {
        return instance;
    }

    public Flow load(String id) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Flow flow = flowDAO.loadByPetalsId(id);
            if (flow != null) {
                this.updateFlowStatusAndDates(flow);
            }
            tx.commit();
            return flow;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void remove(String id) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            flowDAO.remove(flowDAO.loadByPetalsId(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeStep(String flowId, String meUUID, String interfaceName, String serviceName, String endpointName) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStep flowStep = flowStepDAO.loadByMeUUID(meUUID);
            flowStepDAO.remove(flowStep);
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public String saveOrUpdate(Flow flow) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            flowDAO.save(flow);
            String result = flow.getIdpetals();
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowStep> loadSteps(String id) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<FlowStep> result = flowStepDAO.loadByFlowId(id);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowStep> loadRunningSteps(String flowId) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<FlowStep> result = flowStepDAO.loadRunningByFlowId(flowId);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStep loadFlowStep(String flowId, String meUUID, String interfaceName, String serviceName, String endpointName) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStep result = flowStepDAO.loadByMeUUID(meUUID);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowStep> loadFlowSteps(String flowId, String interfaceName, String serviceName) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<FlowStep> result = flowStepDAO.loadByFlowIdAndMeProps(flowId, interfaceName, serviceName);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStep loadFlowStep(long flowStepId) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStep result = (FlowStep)flowStepDAO.find(Long.valueOf(flowStepId));
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<Flow> loadAllStarted() {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<Flow> result = flowDAO.loadAllStarted();
            if (result != null) {
                for (Flow flow : result) {
                    this.updateFlowStatusAndDates(flow);
                }
            }
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void addStep(Flow flow, FlowStep flowStep) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            flowStep.setFlow(flow);
            flowStepDAO.save(flowStep);
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void updateStep(FlowStep flowStep) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            flowStepDAO.save(flowStep);
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<Flow> loadByType(int type) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<Flow> result = flowDAO.loadByType(type);
            if (result != null) {
                for (Flow flow : result) {
                    this.updateFlowStatusAndDates(flow);
                }
            }
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<Flow> loadAllStartedByType(int type) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<Flow> result = flowDAO.loadAllStartedByType(type);
            if (result != null) {
                for (Flow flow : result) {
                    this.updateFlowStatusAndDates(flow);
                }
            }
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<Flow> loadAllStartedByTypeWithDateFilter(int type, Date startDate, Date endDate) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<Flow> result = flowDAO.loadAllStartedByTypeWithDateFilter(type, startDate, endDate);
            if (result != null) {
                for (Flow flow : result) {
                    this.updateFlowStatusAndDates(flow);
                }
            }
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    private void updateFlowStatusAndDates(Flow flow) {
        FlowStepRef endStepRef;
        List<FlowStep> flowSteps;
        FlowStepRef startStepRef = flowStepRefDAO.loadEndStepByFlowType(flow.getType());
        if (startStepRef != null && (flowSteps = flowStepDAO.loadByFlowIdAndMeProps(flow.getIdpetals(), startStepRef.getInterfaceName(), startStepRef.getServiceName())) != null && flowSteps.size() == 1) {
            flow.setStatus(flowSteps.get(0).getStatus());
            flow.setEndDate(flowSteps.get(0).getEndDate());
        }
        if ((endStepRef = flowStepRefDAO.loadStartStepByFlowType(flow.getType())) != null) {
            List<FlowStep> flowSteps2 = flowStepDAO.loadByFlowIdAndMeProps(flow.getIdpetals(), endStepRef.getInterfaceName(), endStepRef.getServiceName());
            if (flowSteps2 != null && flowSteps2.size() == 1) {
                flow.setStartDate(flowSteps2.get(0).getStartDate());
            }
        } else {
            flow.setStatus(-1);
        }
    }

    public List<Flow> getAllFlows(Date after, Date before, RequestOptions requestOptions) {
        return flowDAO.getAllFlows(after, before, requestOptions);
    }

    public int countAllFlows(Date after, Date before, RequestOptions requestOptions) {
        return flowDAO.countAllFlows(after, before, requestOptions);
    }

    public List<FlowWithParams> getAllFlowsByType(Date after, Date before, List<GlobalFlowParam> globalParams, short flowType, RequestOptions requestOptions) {
        return flowDAO.getAllFlowsByType(after, before, globalParams, flowType, requestOptions);
    }

    public int countAllFlowsByType(Date after, Date before, List<GlobalFlowParam> globalParams, short flowType, RequestOptions requestOptions) {
        return flowDAO.countAllFlowsByType(after, before, globalParams, flowType, requestOptions);
    }

    static {
        flowDAO = new FlowDAO();
        flowStepDAO = new FlowStepDAO();
        flowStepRefDAO = FlowStepRefDAO.getInstance();
        instance = new FlowManager();
    }
}

