/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.flowmanager;

import java.util.Date;
import java.util.List;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.ow2.petals.flowwatch.flowmanager.ConfigAndFactoryManager;
import org.ow2.petals.flowwatch.flowmanager.FlowParamsDetails;
import org.ow2.petals.flowwatch.flowmanager.FlowRefManagerRuntimeException;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepRef;
import org.ow2.petals.flowwatch.flowmanager.bo.StepParameter;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowRefDAO;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowStepErrorRefDAO;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowStepRefDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowRefManager
extends ConfigAndFactoryManager {
    private static FlowRefManager instance;
    private static FlowRefDAO flowRefDAO;
    private static FlowStepRefDAO flowStepRefDAO;
    private static FlowStepErrorRefDAO flowStepErrorsRefDAO;

    public static FlowRefManager getInstance() {
        return instance;
    }

    public FlowRef getFlowRef(int type) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowRef result = flowRefDAO.loadByType(type);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowStepRef> loadSteps(int type) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<FlowStepRef> result = flowStepRefDAO.loadByFlowType(type);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStepRef loadStepRef(int type, String interfaceName, String serviceName) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepRef result = flowStepRefDAO.loadByFlowTypeIntNameServName(type, interfaceName, serviceName);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStepRef loadStepRef(long id) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepRef result = (FlowStepRef)flowStepRefDAO.find(Long.valueOf(id));
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public FlowStepErrorRef loadStepErrorRef(long id) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepErrorRef result = (FlowStepErrorRef)flowStepErrorsRefDAO.find(Long.valueOf(id));
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowStepErrorRef> loadStepRefErrors(long stepRefId) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List<FlowStepErrorRef> result = flowStepErrorsRefDAO.loadByStepRefId(stepRefId);
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<FlowRef> loadAll() {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List result = flowRefDAO.findAll();
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public long createFlowRef(int type, String name) {
        FlowRef flowRef = new FlowRef();
        flowRef.setName(name);
        flowRef.setType(type);
        flowRef.setCreationDate(new Date());
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            flowRefDAO.save(flowRef);
            long id = flowRef.getId();
            tx.commit();
            return id;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeFlowRef(int[] flowRefTypes) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            for (int type : flowRefTypes) {
                List<FlowStepRef> steps = flowStepRefDAO.loadByFlowType(type);
                if (steps != null) {
                    for (FlowStepRef step : steps) {
                        flowStepRefDAO.remove(step);
                    }
                }
                flowRefDAO.remove(flowRefDAO.loadByType(type));
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeParameterName(long flowStepId, int index) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepRef result = (FlowStepRef)flowStepRefDAO.find(Long.valueOf(flowStepId));
            result.removeParameterName(index);
            flowStepRefDAO.save(result);
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeParameterNames(long flowStepId, int[] indexes) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepRef result = (FlowStepRef)flowStepRefDAO.find(Long.valueOf(flowStepId));
            this.removeParameterName(result, indexes);
            flowStepRefDAO.save(result);
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeErrorRefs(long[] ids) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            for (long id : ids) {
                flowStepErrorsRefDAO.remove(flowStepErrorsRefDAO.find(Long.valueOf(id)));
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    private void removeParameterName(FlowStepRef flowStepRef, int[] indexes) {
        if (indexes.length > 0) {
            flowStepRef.removeParameterName(indexes[0]);
            int[] decrementedIndexes = new int[indexes.length - 1];
            for (int i = 1; i < indexes.length; ++i) {
                int treatedInt = indexes[i];
                decrementedIndexes[i - 1] = treatedInt > indexes[0] ? treatedInt - 1 : treatedInt;
            }
            this.removeParameterName(flowStepRef, decrementedIndexes);
        }
    }

    public void addParameterName(long flowRefId, String parameterName, boolean global) {
        this.addParameterName(flowRefId, -1, parameterName, global);
    }

    public void addParameterName(long flowStepRefId, int index, String parameterName, boolean global) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepRef flowstepRef = (FlowStepRef)flowStepRefDAO.find(Long.valueOf(flowStepRefId));
            if (index > -1) {
                StepParameter parameter = new StepParameter(parameterName, global);
                flowstepRef.addParameterName(index, parameter);
            } else {
                StepParameter parameter = new StepParameter(parameterName, global);
                flowstepRef.addParameterName(parameter);
            }
            flowStepRefDAO.save(flowstepRef);
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void updateParameterName(long flowStepRefId, int index, String parameterName, boolean global) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepRef flowStepRef = (FlowStepRef)flowStepRefDAO.find(Long.valueOf(flowStepRefId));
            StepParameter parameter = new StepParameter(parameterName, global);
            flowStepRef.updateParameterName(index, parameter);
            flowStepRefDAO.save(flowStepRef);
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public void removeStepRefs(long[] ids) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            for (long id : ids) {
                flowStepRefDAO.remove(flowStepRefDAO.find(Long.valueOf(id)));
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public long saveOrUpdateStepRef(FlowStepRef flowStepRef) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            FlowStepRef existingEndStep;
            FlowStepRef existingStartStep;
            if (flowStepRef.isFlowStartStep() && (existingStartStep = flowStepRefDAO.loadStartStepByFlowType(flowStepRef.getFlowref().getType())) != null) {
                if (existingStartStep.getId() != flowStepRef.getId()) {
                    throw new FlowRefManagerRuntimeException("Already existing start flow step for this type of flow");
                }
                session.evict((Object)existingStartStep);
            }
            if (flowStepRef.isFlowEndStep() && (existingEndStep = flowStepRefDAO.loadEndStepByFlowType(flowStepRef.getFlowref().getType())) != null) {
                if (existingEndStep.getId() != flowStepRef.getId()) {
                    throw new FlowRefManagerRuntimeException("Already existing end flow step for this type of flow");
                }
                session.evict((Object)existingEndStep);
            }
            flowStepRefDAO.save(flowStepRef);
            long result = flowStepRef.getId();
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public long saveOrUpdateErrorRef(FlowStepErrorRef stepErrorRef) {
        Session session = this.configAndFactory.getFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            flowStepErrorsRefDAO.save(stepErrorRef);
            long result = stepErrorRef.getId();
            tx.commit();
            return result;
        }
        catch (RuntimeException e) {
            this.configAndFactory.getFactory().getCurrentSession().getTransaction().rollback();
            throw e;
        }
    }

    public List<GlobalFlowParam> getGlobalFlowParameters(short flowType) {
        List<GlobalFlowParam> result = FlowStepRefDAO.getInstance().getGlobalFlowParameters(flowType);
        return result;
    }

    public List<FlowWithParams> getFlowsWithParameters(List<GlobalFlowParam> globalParams, short type, Date after, Date before) {
        List<FlowWithParams> result = FlowStepRefDAO.getInstance().getFlowsWithParameters(globalParams, type, after, before);
        return result;
    }

    public List<FlowParamsDetails> getDetailFlowParameter(short flowType, String flowId) {
        List<FlowParamsDetails> result = FlowStepRefDAO.getInstance().getDetailFlowParameter(flowType, flowId);
        return result;
    }

    static {
        flowRefDAO = FlowRefDAO.getInstance();
        flowStepRefDAO = FlowStepRefDAO.getInstance();
        flowStepErrorsRefDAO = FlowStepErrorRefDAO.getInstance();
        instance = new FlowRefManager();
    }
}

